/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.jackson.databind.deser.std;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.komamitsu.thirdparty.jackson.annotation.JsonFormat;
import org.komamitsu.thirdparty.jackson.core.JsonParser;
import org.komamitsu.thirdparty.jackson.core.JsonToken;
import org.komamitsu.thirdparty.jackson.core.io.NumberInput;
import org.komamitsu.thirdparty.jackson.databind.AnnotationIntrospector;
import org.komamitsu.thirdparty.jackson.databind.BeanProperty;
import org.komamitsu.thirdparty.jackson.databind.DeserializationContext;
import org.komamitsu.thirdparty.jackson.databind.DeserializationFeature;
import org.komamitsu.thirdparty.jackson.databind.JavaType;
import org.komamitsu.thirdparty.jackson.databind.JsonDeserializer;
import org.komamitsu.thirdparty.jackson.databind.JsonMappingException;
import org.komamitsu.thirdparty.jackson.databind.KeyDeserializer;
import org.komamitsu.thirdparty.jackson.databind.deser.std.StdDelegatingDeserializer;
import org.komamitsu.thirdparty.jackson.databind.introspect.AnnotatedMember;
import org.komamitsu.thirdparty.jackson.databind.jsontype.TypeDeserializer;
import org.komamitsu.thirdparty.jackson.databind.util.ClassUtil;
import org.komamitsu.thirdparty.jackson.databind.util.Converter;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? null : valueType.getRawClass();
    }

    protected StdDeserializer(StdDeserializer<?> src) {
        this._valueClass = src._valueClass;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return ClassUtil.isJacksonStdImpl(deserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return ClassUtil.isJacksonStdImpl(keyDeser);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(p, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text) || text.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text)) {
                return false;
            }
            Boolean b = (Boolean)ctxt.handleWeirdStringValue(this._valueClass, text, "only \"true\" or \"false\" recognized", new Object[0]);
            return b == null ? false : b;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            boolean parsed = this._parseBooleanPrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Boolean)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected final Boolean _parseBoolean(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(p, ctxt);
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue(ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return Boolean.TRUE;
            }
            if ("false".equals(text) || "False".equals(text)) {
                return Boolean.FALSE;
            }
            if (text.length() == 0) {
                return (Boolean)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(text)) {
                return (Boolean)this.getNullValue(ctxt);
            }
            return (Boolean)ctxt.handleWeirdStringValue(this._valueClass, text, "only \"true\" or \"false\" recognized", new Object[0]);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Boolean parsed = this._parseBoolean(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Boolean)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected boolean _parseBooleanFromInt(JsonParser p, DeserializationContext ctxt) throws IOException {
        return !"0".equals(p.getText());
    }

    @Deprecated
    protected boolean _parseBooleanFromOther(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this._parseBooleanFromInt(p, ctxt);
    }

    protected Byte _parseByte(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return p.getByteValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = p.getText().trim();
            if (this._hasTextualNull(text)) {
                return (Byte)this.getNullValue(ctxt);
            }
            try {
                int len = text.length();
                if (len == 0) {
                    return (Byte)this.getEmptyValue(ctxt);
                }
                value = NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                return (Byte)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid Byte value", new Object[0]);
            }
            if (value < -128 || value > 255) {
                return (Byte)ctxt.handleWeirdStringValue(this._valueClass, text, "overflow, value can not be represented as 8-bit value", new Object[0]);
            }
            return (byte)value;
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p, ctxt, "Byte");
            }
            return p.getByteValue();
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Byte parsed = this._parseByte(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Byte)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected Short _parseShort(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return p.getShortValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = p.getText().trim();
            try {
                int len = text.length();
                if (len == 0) {
                    return (Short)this.getEmptyValue(ctxt);
                }
                if (this._hasTextualNull(text)) {
                    return (Short)this.getNullValue(ctxt);
                }
                value = NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                return (Short)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid Short value", new Object[0]);
            }
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                return (Short)ctxt.handleWeirdStringValue(this._valueClass, text, "overflow, value can not be represented as 16-bit value", new Object[0]);
            }
            return (short)value;
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p, ctxt, "Short");
            }
            return p.getShortValue();
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Short parsed = this._parseShort(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Short)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected final short _parseShortPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        int value = this._parseIntPrimitive(p, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, String.valueOf(value), "overflow, value can not be represented as 16-bit value", new Object[0]);
            return v == null ? (short)0 : v.shortValue();
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return p.getIntValue();
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (this._hasTextualNull(text)) {
                return 0;
            }
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "Overflow: numeric value (%s) out of range of int (%d -%d)", text, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        return v == null ? 0 : v.intValue();
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid int value", new Object[0]);
                return v == null ? 0 : v.intValue();
            }
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p, ctxt, "int");
            }
            return p.getValueAsInt();
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            int parsed = this._parseIntPrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).intValue();
    }

    protected final Integer _parseInteger(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return p.getIntValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "Integer");
                }
                return p.getValueAsInt();
            }
            case 6: {
                String text = p.getText().trim();
                try {
                    int len = text.length();
                    if (this._hasTextualNull(text)) {
                        return (Integer)this.getNullValue(ctxt);
                    }
                    if (len > 9) {
                        long l = Long.parseLong(text);
                        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                            return (Integer)ctxt.handleWeirdStringValue(this._valueClass, text, "Overflow: numeric value (" + text + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")", new Object[0]);
                        }
                        return (int)l;
                    }
                    if (len == 0) {
                        return (Integer)this.getEmptyValue(ctxt);
                    }
                    return NumberInput.parseInt(text);
                }
                catch (IllegalArgumentException iae) {
                    return (Integer)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid Integer value", new Object[0]);
                }
            }
            case 11: {
                return (Integer)this.getNullValue(ctxt);
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                Integer parsed = this._parseInteger(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
        }
        return (Integer)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected final Long _parseLong(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return p.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "Long");
                }
                return p.getValueAsLong();
            }
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0) {
                    return (Long)this.getEmptyValue(ctxt);
                }
                if (this._hasTextualNull(text)) {
                    return (Long)this.getNullValue(ctxt);
                }
                try {
                    return NumberInput.parseLong(text);
                }
                catch (IllegalArgumentException iae) {
                    return (Long)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid Long value", new Object[0]);
                }
            }
            case 11: {
                return (Long)this.getNullValue(ctxt);
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                Long parsed = this._parseLong(p, ctxt);
                JsonToken t = p.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
        }
        return (Long)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected final long _parseLongPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return p.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "long");
                }
                return p.getValueAsLong();
            }
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0 || this._hasTextualNull(text)) {
                    return 0L;
                }
                try {
                    return NumberInput.parseLong(text);
                }
                catch (IllegalArgumentException iae) {
                    Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid long value", new Object[0]);
                    return v == null ? 0L : v.longValue();
                }
            }
            case 11: {
                return 0L;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                long parsed = this._parseLongPrimitive(p, ctxt);
                JsonToken t = p.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).longValue();
    }

    protected final Float _parseFloat(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(p.getFloatValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (text.length() == 0) {
                return (Float)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(text)) {
                return (Float)this.getNullValue(ctxt);
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(text));
            }
            catch (IllegalArgumentException iae) {
                return (Float)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid Float value", new Object[0]);
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Float parsed = this._parseFloat(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Float)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected final float _parseFloatPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getFloatValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0.0f;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(text);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid float value", new Object[0]);
                return v == null ? 0.0f : v.floatValue();
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            float parsed = this._parseFloatPrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).floatValue();
    }

    protected final Double _parseDouble(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (text.length() == 0) {
                return (Double)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(text)) {
                return (Double)this.getNullValue(ctxt);
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text);
            }
            catch (IllegalArgumentException iae) {
                return (Double)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid Double value", new Object[0]);
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Double parsed = this._parseDouble(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Double)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected final double _parseDoublePrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0.0;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid double value", new Object[0]);
                return v == null ? 0.0 : v.doubleValue();
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            double parsed = this._parseDoublePrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).doubleValue();
    }

    protected Date _parseDate(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(p.getLongValue());
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue(ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            return this._parseDate(p.getText().trim(), ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Date parsed = this._parseDate(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Date)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected Date _parseDate(String value, DeserializationContext ctxt) throws IOException {
        try {
            if (value.length() == 0) {
                return (Date)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(value)) {
                return (Date)this.getNullValue(ctxt);
            }
            return ctxt.parseDate(value);
        }
        catch (IllegalArgumentException iae) {
            return (Date)ctxt.handleWeirdStringValue(this._valueClass, value, "not a valid representation (error: %s)", iae.getMessage());
        }
    }

    protected static final double parseDouble(String numStr) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr);
    }

    protected final String _parseString(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            return p.getText();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            String parsed = this._parseString(p, ctxt);
            if (p.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        String value = p.getValueAsString();
        if (value != null) {
            return value;
        }
        return (String)ctxt.handleUnexpectedToken(String.class, p);
    }

    protected T _deserializeFromEmpty(JsonParser p, DeserializationContext ctxt) throws IOException {
        String str;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_ARRAY) {
            if (ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                t = p.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    return null;
                }
                return (T)ctxt.handleUnexpectedToken(this.handledType(), p);
            }
        } else if (t == JsonToken.VALUE_STRING && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p.getText().trim()).isEmpty()) {
            return null;
        }
        return (T)ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected final boolean _isNegInf(String text) {
        return "-Infinity".equals(text) || "-INF".equals(text);
    }

    protected final boolean _isPosInf(String text) {
        return "Infinity".equals(text) || "INF".equals(text);
    }

    protected final boolean _isNaN(String text) {
        return "NaN".equals(text);
    }

    protected Object _coerceIntegral(JsonParser p, DeserializationContext ctxt) throws IOException {
        int feats = ctxt.getDeserializationFeatures();
        if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(feats)) {
            return p.getBigIntegerValue();
        }
        if (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(feats)) {
            return p.getLongValue();
        }
        return p.getBigIntegerValue();
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type, BeanProperty property) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type, property);
    }

    protected final boolean _isIntNumber(String text) {
        int len = text.length();
        if (len > 0) {
            int i;
            char c = text.charAt(0);
            int n = i = c == '-' || c == '+' ? 1 : 0;
            while (i < len) {
                char ch = text.charAt(i);
                if (ch > '9' || ch < '0') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> existingDeserializer) throws JsonMappingException {
        Object convDef;
        AnnotatedMember member;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && prop != null && (member = prop.getMember()) != null && (convDef = intr.findDeserializationContentConverter(member)) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (existingDeserializer == null) {
                existingDeserializer = ctxt.findContextualValueDeserializer(delegateType, prop);
            }
            return new StdDelegatingDeserializer<Object>(conv, delegateType, existingDeserializer);
        }
        return existingDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(ctxt.getConfig(), typeForDefaults);
        }
        return ctxt.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, prop, typeForDefaults);
        if (format != null) {
            return format.getFeature(feat);
        }
        return null;
    }

    protected void handleUnknownProperty(JsonParser p, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException {
        if (instanceOrClass == null) {
            instanceOrClass = this.handledType();
        }
        if (ctxt.handleUnknownProperty(p, this, instanceOrClass, propName)) {
            return;
        }
        p.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser p, DeserializationContext ctxt) throws IOException {
        ctxt.reportWrongTokenException(p, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single '%s' value but there was more than a single value in the array", this.handledType().getName());
    }

    protected void _failDoubleToIntCoercion(JsonParser p, DeserializationContext ctxt, String type) throws IOException {
        ctxt.reportMappingException("Can not coerce a floating-point value ('%s') into %s; enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow", p.getValueAsString(), type);
    }
}

