/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.jackson.databind;

import java.io.IOException;
import java.util.Collection;
import org.komamitsu.thirdparty.jackson.core.JsonParser;
import org.komamitsu.thirdparty.jackson.core.JsonProcessingException;
import org.komamitsu.thirdparty.jackson.databind.DeserializationContext;
import org.komamitsu.thirdparty.jackson.databind.JsonMappingException;
import org.komamitsu.thirdparty.jackson.databind.deser.SettableBeanProperty;
import org.komamitsu.thirdparty.jackson.databind.deser.impl.ObjectIdReader;
import org.komamitsu.thirdparty.jackson.databind.jsontype.TypeDeserializer;
import org.komamitsu.thirdparty.jackson.databind.util.NameTransformer;

public abstract class JsonDeserializer<T> {
    public abstract T deserialize(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException, JsonProcessingException {
        throw new UnsupportedOperationException("Can not update object of type " + intoValue.getClass().getName() + " (by deserializer of type " + this.getClass().getName() + ")");
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    public JsonDeserializer<T> unwrappingDeserializer(NameTransformer unwrapper) {
        return this;
    }

    public JsonDeserializer<?> replaceDelegatee(JsonDeserializer<?> delegatee) {
        throw new UnsupportedOperationException();
    }

    public Class<?> handledType() {
        return null;
    }

    public boolean isCachable() {
        return false;
    }

    public JsonDeserializer<?> getDelegatee() {
        return null;
    }

    public Collection<Object> getKnownPropertyNames() {
        return null;
    }

    public T getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return this.getNullValue();
    }

    public T getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return this.getEmptyValue();
    }

    public ObjectIdReader getObjectIdReader() {
        return null;
    }

    public SettableBeanProperty findBackReference(String refName) {
        throw new IllegalArgumentException("Can not handle managed/back reference '" + refName + "': type: value deserializer of type " + this.getClass().getName() + " does not support them");
    }

    @Deprecated
    public T getNullValue() {
        return null;
    }

    @Deprecated
    public T getEmptyValue() {
        return this.getNullValue();
    }

    public static abstract class None
    extends JsonDeserializer<Object> {
        private None() {
        }
    }
}

