/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.ingester.Ingester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Flusher
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    protected final Buffer buffer;
    protected final Ingester ingester;
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final Config config;

    protected Flusher(Config config, Buffer buffer, Ingester ingester) {
        this.config = config;
        this.buffer = buffer;
        this.ingester = ingester;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected abstract void flushInternal(boolean var1) throws IOException;

    protected abstract void beforeClosingBuffer() throws IOException;

    public void onUpdate() throws IOException {
        this.flushInternal(false);
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.beforeClosingBuffer();
        }
        catch (Exception e) {
            LOG.error("Failed to call beforeClosingBuffer()", e);
        }
        finally {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Void> future = executorService.submit(() -> {
                this.closeBuffer();
                this.isTerminated.set(true);
                return null;
            });
            try {
                future.get(this.config.getWaitUntilTerminated(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted", e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.warn("closeBuffer() failed", e);
            }
            catch (TimeoutException e) {
                LOG.warn("closeBuffer() timed out", e);
            }
            finally {
                try {
                    executorService.shutdown();
                }
                finally {
                    try {
                        this.ingester.close();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to close the sender", e);
                    }
                }
            }
        }
    }

    public boolean isTerminated() {
        return this.isTerminated.get();
    }

    private void closeBuffer() {
        LOG.trace("closeBuffer(): closing buffer");
        this.buffer.close();
    }

    public Ingester getIngester() {
        return this.ingester;
    }

    public int getFlushIntervalMillis() {
        return this.config.getFlushIntervalMillis();
    }

    public int getWaitUntilBufferFlushed() {
        return this.config.getWaitUntilBufferFlushed();
    }

    public int getWaitUntilTerminated() {
        return this.config.getWaitUntilTerminated();
    }

    public String toString() {
        return "Flusher{isTerminated=" + this.isTerminated + ", buffer=" + this.buffer + ", ingester=" + this.ingester + ", config=" + this.config + '}';
    }

    public static abstract class Config {
        private int flushIntervalMillis = 600;
        private int waitUntilBufferFlushed = 60;
        private int waitUntilTerminated = 60;

        public int getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public void setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
        }

        public int getWaitUntilBufferFlushed() {
            return this.waitUntilBufferFlushed;
        }

        public void setWaitUntilBufferFlushed(int waitUntilBufferFlushed) {
            this.waitUntilBufferFlushed = waitUntilBufferFlushed;
        }

        public int getWaitUntilTerminated() {
            return this.waitUntilTerminated;
        }

        public void setWaitUntilTerminated(int waitUntilTerminated) {
            this.waitUntilTerminated = waitUntilTerminated;
        }

        public String toString() {
            return "Config{flushIntervalMillis=" + this.flushIntervalMillis + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilTerminated=" + this.waitUntilTerminated + '}';
        }
    }
}

