/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.ingester.Ingester;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFlusher
extends Flusher {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFlusher.class);
    private final BlockingQueue<Boolean> eventQueue = new LinkedBlockingQueue<Boolean>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Config config;
    private final Runnable task = () -> {
        Boolean wakeup = null;
        do {
            try {
                wakeup = this.eventQueue.poll(this.config.getFlushIntervalMillis(), TimeUnit.MILLISECONDS);
                boolean force = wakeup != null;
                this.buffer.flush(this.ingester, force);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOG.error("Failed to flush", e);
            }
        } while (!this.executorService.isShutdown());
        if (wakeup == null) {
            try {
                this.buffer.flush(this.ingester, true);
            }
            catch (IOException e) {
                LOG.error("Failed to flush", e);
            }
        }
    };

    public AsyncFlusher(Buffer buffer, Ingester ingester) {
        this(new Config(), buffer, ingester);
    }

    public AsyncFlusher(Config config, Buffer buffer, Ingester ingester) {
        super(config, buffer, ingester);
        this.config = config;
        this.executorService.execute(this.task);
    }

    @Override
    protected void flushInternal(boolean force) {
        if (force) {
            try {
                this.eventQueue.put(true);
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to force flushing buffer", e);
            }
        }
    }

    @Override
    protected void beforeClosingBuffer() throws IOException {
        try {
            this.eventQueue.put(true);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to close buffer", e);
        }
        finally {
            ExecutorServiceUtils.finishExecutorService(this.executorService, this.config.getWaitUntilBufferFlushed());
        }
    }

    @Override
    public String toString() {
        return "AsyncFlusher{eventQueue=" + this.eventQueue + ", config=" + this.config + ", task=" + this.task + "} " + super.toString();
    }

    public static class Config
    extends Flusher.Config {
    }
}

