/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions.cmpn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.cmpn.ConfigurationAdminUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;

public class ConfigurationAdminAssert
extends OSGiAssert {
    private ConfigurationAdminAssert() {
    }

    public static void assertConfigurationAvailable(String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationAvailable(String.format("Configuration is unavailable for PID: %s, FactoryPID: %s, Location: %s", pid, factoryPid, location), pid, factoryPid, location);
    }

    public static void assertConfigurationAvailable(String message, String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationAvailable(message, ConfigurationAdminUtils.createConfigurationFilter((String)pid, (String)factoryPid, (String)location));
    }

    public static void assertConfigurationAvailable(Filter filter) {
        ConfigurationAdminAssert.assertConfigurationAvailable(String.format("Configuration is unavailable for Filter: %s", filter), filter);
    }

    public static void assertConfigurationAvailable(String message, Filter filter) {
        try {
            Configuration[] configurations = ConfigurationAdminUtils.listConfigurations((BundleContext)ConfigurationAdminAssert.getBundleContext(), (Filter)filter);
            Assert.assertNotNull((String)message, (Object)configurations);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertConfigurationUnavailable(String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(String.format("Configuration is available for PID: %s, FactoryPID: %s, Location: %s", pid, factoryPid, location), pid, factoryPid, location);
    }

    public static void assertConfigurationUnavailable(String message, String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(message, ConfigurationAdminUtils.createConfigurationFilter((String)pid, (String)factoryPid, (String)location));
    }

    public static void assertConfigurationUnavailable(Filter filter) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(String.format("Configuration is unavailable for Filter: %s", filter), filter);
    }

    public static void assertConfigurationUnavailable(String message, Filter filter) {
        try {
            Configuration[] configurations = ConfigurationAdminUtils.listConfigurations((BundleContext)ConfigurationAdminAssert.getBundleContext(), (Filter)filter);
            Assert.assertNull((String)message, (Object)configurations);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertConfigurationAvailable(BundleContext bc, String pid, String factoryPid) {
        Assert.assertNotNull((String)"BundleContext is null", (Object)bc);
        ConfigurationAdminAssert.assertConfigurationAvailable(String.format("Configuration is unavailable for BundleId: %s, PID: %s, FactoryPID: %s", bc.getBundle().getBundleId(), pid, factoryPid), bc, pid, factoryPid);
    }

    public static void assertConfigurationAvailable(String message, BundleContext bc, String pid, String factoryPid) {
        ConfigurationAdminAssert.assertConfigurationAvailable(message, bc, ConfigurationAdminUtils.createConfigurationFilter((String)pid, (String)factoryPid, (String)bc.getBundle().getLocation()));
    }

    public static void assertConfigurationAvailable(BundleContext bc, Filter filter) {
        Assert.assertNotNull((String)"BundleContext is null", (Object)bc);
        ConfigurationAdminAssert.assertConfigurationAvailable(String.format("Configuration is unavailable for BundleId: %s, Filter: %s", bc.getBundle().getBundleId(), filter), bc, filter);
    }

    public static void assertConfigurationAvailable(String message, BundleContext bc, Filter filter) {
        Assert.assertNotNull((String)"BundleContext is null", (Object)bc);
        try {
            Configuration[] configurations = ConfigurationAdminUtils.listConfigurations((BundleContext)bc, (Filter)filter);
            Assert.assertNotNull((String)message, (Object)configurations);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertConfigurationUnavailable(BundleContext bc, String pid, String factoryPid) {
        Assert.assertNotNull((String)"BundleContext is null", (Object)bc);
        ConfigurationAdminAssert.assertConfigurationUnavailable(String.format("Configuration is available for BundleId: %s, PID: %s, FactoryPID: %s", bc.getBundle().getBundleId(), pid, factoryPid), bc, pid, factoryPid);
    }

    public static void assertConfigurationUnavailable(String message, BundleContext bc, String pid, String factoryPid) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(message, bc, ConfigurationAdminUtils.createConfigurationFilter((String)pid, (String)factoryPid, (String)bc.getBundle().getLocation()));
    }

    public static void assertConfigurationUnavailable(BundleContext bc, Filter filter) {
        Assert.assertNotNull((String)"BundleContext is null", (Object)bc);
        ConfigurationAdminAssert.assertConfigurationUnavailable(String.format("Configuration is unavailable for BundleId: %s, Filter: %s", bc.getBundle().getBundleId(), filter), bc, filter);
    }

    public static void assertConfigurationUnavailable(String message, BundleContext bc, Filter filter) {
        Assert.assertNotNull((String)"BundleContext is null", (Object)bc);
        try {
            Configuration[] configurations = ConfigurationAdminUtils.listConfigurations((BundleContext)bc, (Filter)filter);
            Assert.assertNull((String)message, (Object)configurations);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertConfigurationEvent(int eventTypeMask, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(String.format("ConfigurationEvent is unavailable: %s within timeout: %sms", eventTypeMask, timeoutInMillis), eventTypeMask, timeoutInMillis);
    }

    public static void assertConfigurationEvent(int eventTypeMask, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(String.format("ConfigurationEvent is unavailable: %s for PID: %s, FactoryPID: %s, Location: %s within timeout: %sms", eventTypeMask, pid, factoryPid, location, timeoutInMillis), eventTypeMask, pid, factoryPid, location, timeoutInMillis);
    }

    public static void assertConfigurationUpdated(String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationUpdated(String.format("ConfigurationEvent is unavailable: CM_UPDATED for PID: %s, FactoryPID: %s, Location: %s within timeout: %sms", pid, factoryPid, location, timeoutInMillis), pid, factoryPid, location, timeoutInMillis);
    }

    public static void assertConfigurationDeleted(String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationDeleted(String.format("ConfigurationEvent is unavailable: CM_DELETED for PID: %s, FactoryPID: %s, Location: %s within timeout: %sms", pid, factoryPid, location, timeoutInMillis), pid, factoryPid, location, timeoutInMillis);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, eventTypeMask, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationUpdated(String message, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationUpdated(message, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationDeleted(String message, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationDeleted(message, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationEvent(int eventTypeMask, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationEvent(String.format("ConfigurationEvent is unavailable: %s within timeout: %s%s", new Object[]{eventTypeMask, timeout, timeUnit}), eventTypeMask, null, null, null, timeout, timeUnit);
    }

    public static void assertConfigurationEvent(int eventTypeMask, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationEvent(String.format("ConfigurationEvent is unavailable: %s for PID: %s, FactoryPID: %s, Location: %s within timeout: %s%s", new Object[]{eventTypeMask, pid, factoryPid, location, timeout, timeUnit}), eventTypeMask, pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationUpdated(String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationUpdated(String.format("ConfigurationEvent is unavailable: CM_UPDATED for PID: %s, FactoryPID: %s, Location: %s within timeout: %s%s", new Object[]{pid, factoryPid, location, timeout, timeUnit}), pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationDeleted(String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationDeleted(String.format("ConfigurationEvent is unavailable: CM_DELETED for PID: %s, FactoryPID: %s, Location: %s within timeout: %s%s", new Object[]{pid, factoryPid, location, timeout, timeUnit}), pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationEvent(message, eventTypeMask, null, null, null, timeout, timeUnit);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationEvent event = ConfigurationAdminUtils.waitForConfigurationEvent((BundleContext)ConfigurationAdminAssert.getBundleContext(), (int)eventTypeMask, (String)pid, (String)factoryPid, (String)location, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }

    public static void assertConfigurationUpdated(String message, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationEvent(message, 1, pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationDeleted(String message, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        ConfigurationAdminAssert.assertConfigurationEvent(message, 2, pid, factoryPid, location, timeout, timeUnit);
    }
}

