/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.BundleUtils;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleAssert
extends OSGiAssert {
    private BundleAssert() {
    }

    public static void assertBundleState(int state, long bundleId) {
        BundleAssert.assertBundleState(String.format("Invalid state of bundle: %s", bundleId), state, bundleId);
    }

    public static void assertBundleState(String message, int state, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        Assert.assertEquals((String)message, (long)state, (long)bundle.getState());
    }

    public static void assertBundleState(int state, String symbolicName) {
        BundleAssert.assertBundleState(String.format("Invalid state of bundle: %s", symbolicName), state, symbolicName);
    }

    public static void assertBundleState(int state, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleState(String.format("Invalid state %s of bundle: %s within timeout: %sms", state, symbolicName, timeoutInMillis), state, symbolicName, null, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleState(String message, int stateMask, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleState(message, stateMask, symbolicName, null, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleState(String message, int stateMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleState(message, stateMask, symbolicName, null, timeout, timeUnit);
    }

    public static void assertBundleState(String message, int state, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s", symbolicName), (Object)bundle);
        Assert.assertEquals((String)message, (long)state, (long)bundle.getState());
    }

    public static void assertBundleState(String message, int stateMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version, (int)stateMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleState(int state, String symbolicName, Version version) {
        BundleAssert.assertBundleState(String.format("Invalid state of bundle: %s[%s]", symbolicName, version), state, symbolicName, version);
    }

    public static void assertBundleState(int stateMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleState(String.format("Invalid state %s of bundle: %s[%s] within timeout: %s%s", new Object[]{stateMask, symbolicName, version, timeout, timeUnit}), stateMask, symbolicName, version, timeout, timeUnit);
    }

    public static void assertBundleState(int stateMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleState(String.format("Invalid state %s of bundle: %s within timeout: %s%s", new Object[]{stateMask, symbolicName, timeout, timeUnit}), stateMask, symbolicName, null, timeout, timeUnit);
    }

    public static void assertBundleState(String message, int state, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), (Object)bundle);
        Assert.assertEquals((String)message, (long)state, (long)bundle.getState());
    }

    public static void assertBundleAvailable(long bundleId) {
        BundleAssert.assertBundleAvailable(String.format("Bundle: %s is unavailable", bundleId), bundleId);
    }

    public static void assertBundleAvailable(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleAvailable(String symbolicName) {
        BundleAssert.assertBundleAvailable(String.format("Bundle: %s is unavailable", symbolicName), symbolicName);
    }

    public static void assertBundleAvailable(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleAvailable(String symbolicName, Version version) {
        BundleAssert.assertBundleAvailable(String.format("Bundle: %s[%s] is unavailable", symbolicName, version), symbolicName, version);
    }

    public static void assertBundleAvailable(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)message, (Object)bundle);
    }

    public static void assertBundleUnavailable(long bundleId) {
        BundleAssert.assertBundleUnavailable(String.format("Bundle: %s is available", bundleId), bundleId);
    }

    public static void assertBundleUnavailable(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNull((String)message, (Object)bundle);
    }

    public static void assertBundleUnavailable(String symbolicName) {
        BundleAssert.assertBundleUnavailable(String.format("Bundle: %s is available", symbolicName), symbolicName);
    }

    public static void assertBundleUnavailable(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNull((String)message, (Object)bundle);
    }

    public static void assertBundleUnavailable(String symbolicName, Version version) {
        BundleAssert.assertBundleUnavailable(String.format("Bundle: %s[%s] is available", symbolicName, version), symbolicName, version);
    }

    public static void assertBundleUnavailable(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNull((String)message, (Object)bundle);
    }

    public static void assertFragment(long bundleId) {
        BundleAssert.assertFragment(String.format("Bundle: %s is not a fragment", bundleId), bundleId);
    }

    public static void assertFragment(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertFragment(String symbolicName) {
        BundleAssert.assertFragment(String.format("Bundle: %s is not a fragment", symbolicName), symbolicName);
    }

    public static void assertFragment(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s", symbolicName), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertFragment(String symbolicName, Version version) {
        BundleAssert.assertFragment(String.format("Bundle: %s[%s] is not a fragment", symbolicName, version), symbolicName, version);
    }

    public static void assertFragment(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertNotFragment(long bundleId) {
        BundleAssert.assertNotFragment(String.format("Bundle: %s is a fragment", bundleId), bundleId);
    }

    public static void assertNotFragment(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertNotFragment(String symbolicName) {
        BundleAssert.assertNotFragment(String.format("Bundle: %s is a fragment", symbolicName), symbolicName);
    }

    public static void assertNotFragment(String message, String symbolicName) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s", symbolicName), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertNotFragment(String symbolicName, Version version) {
        BundleAssert.assertNotFragment(String.format("Bundle: %s[%s] is a fragment", symbolicName, version), symbolicName, version);
    }

    public static void assertNotFragment(String message, String symbolicName, Version version) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version);
        Assert.assertNotNull((String)String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), (Object)bundle);
        PackageAdmin packageAdmin = (PackageAdmin)ServiceUtils.getService((BundleContext)BundleAssert.getBundleContext(), PackageAdmin.class);
        Assert.assertNotNull((String)"PackageAdmin is unavailable", (Object)packageAdmin);
        int type = packageAdmin.getBundleType(bundle);
        Assert.assertTrue((String)message, ((type & 1) != 0 ? 1 : 0) != 0);
    }

    public static void assertBundleEvent(int eventTypeMask, int bundleId, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, bundleId, timeoutInMillis), eventTypeMask, bundleId, timeoutInMillis);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, int bundleId, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(message, eventTypeMask, bundleId, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleEvent(int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, bundleId, timeout, timeUnit}), eventTypeMask, bundleId, timeout, timeUnit);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)BundleAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        BundleEvent event = BundleUtils.waitForBundleEvent((BundleContext)BundleAssert.getBundleContext(), (int)bundleId, (int)eventTypeMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, symbolicName, timeoutInMillis), eventTypeMask, symbolicName, timeoutInMillis);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(message, eventTypeMask, symbolicName, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, symbolicName, timeout, timeUnit}), eventTypeMask, symbolicName, timeout, timeUnit);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        BundleEvent event = BundleUtils.waitForBundleEvent((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (int)eventTypeMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s[%s] within timeout: %sms", eventTypeMask, symbolicName, version, timeoutInMillis), eventTypeMask, symbolicName, version, timeoutInMillis);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(message, eventTypeMask, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, long timeout, Version version, TimeUnit timeUnit) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s[%s] within timeout: %s%s", new Object[]{eventTypeMask, symbolicName, version, timeout, timeUnit}), eventTypeMask, symbolicName, version, timeout, timeUnit);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        BundleEvent event = BundleUtils.waitForBundleEvent((BundleContext)BundleAssert.getBundleContext(), (String)symbolicName, (Version)version, (int)eventTypeMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }
}

