/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions.cmpn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.cmpn.ConfigurationAdminUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;

public class ConfigurationAdminAssert
extends OSGiAssert {
    private ConfigurationAdminAssert() {
    }

    public static void assertConfigurationAvailable(String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationAvailable(null, pid, factoryPid, location);
    }

    public static void assertConfigurationAvailable(String message, String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationAvailable(message, ConfigurationAdminUtils.createConfigurationFilter((String)pid, (String)factoryPid, (String)location));
    }

    public static void assertConfigurationAvailable(Filter filter) {
        ConfigurationAdminAssert.assertConfigurationAvailable(null, filter);
    }

    public static void assertConfigurationAvailable(String message, Filter filter) {
        try {
            Configuration[] configurations = ConfigurationAdminUtils.listConfigurations((BundleContext)ConfigurationAdminAssert.getBundleContext(), (Filter)filter);
            Assert.assertNotNull((String)message, (Object)configurations);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertConfigurationUnavailable(String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(null, pid, factoryPid, location);
    }

    public static void assertConfigurationUnavailable(String message, String pid, String factoryPid, String location) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(message, ConfigurationAdminUtils.createConfigurationFilter((String)pid, (String)factoryPid, (String)location));
    }

    public static void assertConfigurationUnavailable(Filter filter) {
        ConfigurationAdminAssert.assertConfigurationUnavailable(null, filter);
    }

    public static void assertConfigurationUnavailable(String message, Filter filter) {
        try {
            Configuration[] configurations = ConfigurationAdminUtils.listConfigurations((BundleContext)ConfigurationAdminAssert.getBundleContext(), (Filter)filter);
            Assert.assertNull((String)message, (Object)configurations);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertConfigurationEvent(int eventTypeMask, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(null, eventTypeMask, timeoutInMillis);
    }

    public static void assertConfigurationEvent(int eventTypeMask, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(null, eventTypeMask, pid, factoryPid, location, timeoutInMillis);
    }

    public static void assertConfigurationUpdated(String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationUpdated(null, pid, factoryPid, location, timeoutInMillis);
    }

    public static void assertConfigurationDeleted(String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationDeleted(null, pid, factoryPid, location, timeoutInMillis);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, eventTypeMask, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationUpdated(String message, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationUpdated(message, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationDeleted(String message, String pid, String factoryPid, String location, long timeoutInMillis) {
        ConfigurationAdminAssert.assertConfigurationDeleted(message, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertConfigurationEvent(int eventTypeMask, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationEvent(null, eventTypeMask, null, null, null, timeout, timeUnit);
    }

    public static void assertConfigurationEvent(int eventTypeMask, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationEvent(null, eventTypeMask, pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationUpdated(String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationUpdated(null, pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationDeleted(String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationDeleted(null, pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, eventTypeMask, null, null, null, timeout, timeUnit);
    }

    public static void assertConfigurationEvent(String message, int eventTypeMask, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        ConfigurationEvent event = ConfigurationAdminUtils.waitForConfigurationEvent((BundleContext)ConfigurationAdminAssert.getBundleContext(), (int)eventTypeMask, (String)pid, (String)factoryPid, (String)location, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }

    public static void assertConfigurationUpdated(String message, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, 1, pid, factoryPid, location, timeout, timeUnit);
    }

    public static void assertConfigurationDeleted(String message, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        ConfigurationAdminAssert.assertConfigurationEvent(message, 2, pid, factoryPid, location, timeout, timeUnit);
    }
}

