/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.BundleUtils;
import org.knowhowlab.osgi.testing.utils.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.Version;

public class FrameworkAssert
extends OSGiAssert {
    private FrameworkAssert() {
    }

    public static void assertFrameworkEvent(int eventTypeMask, int bundleId, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(null, eventTypeMask, bundleId, timeoutInMillis);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, int bundleId, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(message, eventTypeMask, bundleId, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        FrameworkAssert.assertFrameworkEvent(null, eventTypeMask, bundleId, timeout, timeUnit);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        Bundle bundle = BundleUtils.findBundle((BundleContext)FrameworkAssert.getBundleContext(), (long)bundleId);
        Assert.assertNotNull((String)String.format("Unknown bundle with ID: %d", bundleId), (Object)bundle);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        FrameworkEvent event = FrameworkUtils.waitForFrameworkEvent((BundleContext)FrameworkAssert.getBundleContext(), (int)bundleId, (int)eventTypeMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(null, eventTypeMask, symbolicName, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(eventTypeMask, symbolicName, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        FrameworkAssert.assertFrameworkEvent(null, eventTypeMask, symbolicName, timeout, timeUnit);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        FrameworkEvent event = FrameworkUtils.waitForFrameworkEvent((BundleContext)FrameworkAssert.getBundleContext(), (String)symbolicName, (int)eventTypeMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(eventTypeMask, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(message, eventTypeMask, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        FrameworkAssert.assertFrameworkEvent(null, eventTypeMask, symbolicName, version, timeout, timeUnit);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        Assert.assertNotNull((String)"SymbolicName is null", (Object)symbolicName);
        Assert.assertNotNull((String)"TimeUnit is null", (Object)((Object)timeUnit));
        FrameworkEvent event = FrameworkUtils.waitForFrameworkEvent((BundleContext)FrameworkAssert.getBundleContext(), (String)symbolicName, (Version)version, (int)eventTypeMask, (long)timeout, (TimeUnit)timeUnit);
        Assert.assertNotNull((String)message, (Object)event);
    }
}

