/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x.msg;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.klojang.check.x.ArrayInfo;
import org.klojang.check.x.Misc;
import org.klojang.check.x.msg.CustomMsgFormatter;
import org.klojang.check.x.msg.MsgArgs;

public final class MsgUtil {
    public static final String DEF_ARG_NAME = "argument";
    public static final int MAX_STRING_WIDTH = 65;
    public static final String WAS = " (was ";

    private MsgUtil() {
        throw new UnsupportedOperationException();
    }

    public static String getDefaultPredicateMessage(String argName, Object argVal) {
        if (argName == null) {
            return "invalid value: " + MsgUtil.toStr(argVal);
        }
        return "invalid value for " + argName + ": " + MsgUtil.toStr(argVal);
    }

    public static String getDefaultRelationMessage(String argName, Object argVal, Object obj) {
        if (argName == null) {
            return "no such relation between " + MsgUtil.toStr(argVal) + " and " + MsgUtil.toStr(obj);
        }
        return "invalid value for " + argName + ": no such relation between " + MsgUtil.toStr(argVal) + " and " + MsgUtil.toStr(obj);
    }

    public static String getPrefabMessage(Function<MsgArgs, String> formatter, Object test, boolean negated, String argName, Object argVal, Class<?> argType, Object obj) {
        return formatter.apply(new MsgArgs(test, negated, argName, argVal, argType, obj));
    }

    public static String getCustomMessage(String msg, Object[] msgArgs, Object test, String argName, Object argVal, Class<?> argType, Object obj) {
        if (msgArgs == null || msg == null) {
            return msg;
        }
        if (msgArgs.length == 0) {
            return CustomMsgFormatter.formatWithPrefabArgs(msg, new Object[]{test, argVal, argType, argName, obj});
        }
        Object[] all = new Object[msgArgs.length + 5];
        all[0] = test;
        all[1] = argVal;
        all[2] = argType;
        all[3] = argName;
        all[4] = obj;
        System.arraycopy(msgArgs, 0, all, 5, msgArgs.length);
        return CustomMsgFormatter.format(msg, all);
    }

    public static String toStr(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof String) {
            String s = (String)val;
            return s.isBlank() ? "\"" + Misc.ellipsis(s, 65) + "\"" : Misc.ellipsis(s, 65);
        }
        if (val instanceof Collection) {
            Collection c = (Collection)val;
            if (c.size() == 0) {
                return c.getClass().getSimpleName() + "[0]";
            }
            String s = Misc.toShortString(val, 65);
            return c.getClass().getSimpleName() + "[" + c.size() + "] of " + s;
        }
        if (val instanceof Map) {
            Map m = (Map)val;
            if (m.size() == 0) {
                return m.getClass().getSimpleName() + "[0]";
            }
            String s = Misc.toShortString(val, 65);
            return m.getClass().getSimpleName() + "[" + m.size() + "] of " + s;
        }
        if (val.getClass().isArray()) {
            int len = Misc.getArrayLength(val);
            if (len == 0) {
                return ArrayInfo.describe(val);
            }
            return ArrayInfo.describe(val) + " of " + Misc.toShortString(val, 65);
        }
        return Misc.toShortString(val, 65);
    }

    public static String className(Object obj) {
        if (obj.getClass().getPackageName().startsWith("java.lang")) {
            return MsgUtil.simpleClassName(obj);
        }
        return obj.getClass() == Class.class ? Misc.className((Class)obj) : Misc.className(obj.getClass());
    }

    public static String simpleClassName(Object obj) {
        return obj.getClass() == Class.class ? Misc.simpleClassName((Class)obj) : Misc.simpleClassName(obj.getClass());
    }

    public static String identify(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Enum) {
            Enum e = (Enum)arg;
            return e.name();
        }
        if (arg instanceof Class) {
            Class c = (Class)arg;
            return MsgUtil.simpleClassName(c) + ".class";
        }
        return MsgUtil.simpleClassName(arg) + "@" + System.identityHashCode(arg);
    }
}

