/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x.msg;

import org.klojang.check.x.ArrayInfo;
import org.klojang.check.x.msg.MsgUtil;
import org.klojang.check.x.msg.PrefabMsgFormatter;

final class MsgPredicate {
    private MsgPredicate() {
    }

    static PrefabMsgFormatter msgNull() {
        return x -> x.negated() ? x.name() + " must not be null" : x.name() + " must be null (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgNotNull() {
        return x -> x.negated() ? x.name() + " must be null (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must not be null";
    }

    static PrefabMsgFormatter msgYes() {
        return x -> x.negated() ? x.name() + " must not be true" : x.name() + " must be true";
    }

    static PrefabMsgFormatter msgNo() {
        return x -> x.negated() ? x.name() + " must not be false" : x.name() + " must be false";
    }

    static PrefabMsgFormatter msgEmpty() {
        return x -> x.negated() ? x.name() + " must not be null or empty (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must be null or empty (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgNotEmpty() {
        return x -> x.negated() ? x.name() + " must be null or empty (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must not be null or empty (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgDeepNotNull() {
        return x -> x.negated() ? x.name() + " must be null or contain null values (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must not be null or contain null values (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgDeepNotEmpty() {
        return x -> x.negated() ? x.name() + " must be empty or contain empty values (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must not be empty or contain empty values (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgBlank() {
        return x -> x.negated() ? x.name() + " must not be null or blank (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must be null or blank (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgPlainInt() {
        return x -> x.negated() ? x.name() + " must not be a plain integer (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must be a plain integer: no +/- sign, no leading zeros (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgPlainShort() {
        return x -> x.negated() ? x.name() + " must not be a plain short (was " + MsgUtil.toStr(x.arg()) + ")" : x.name() + " must be a plain 16-bit integer: no +/- sign, no leading zeros (was " + MsgUtil.toStr(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgArray() {
        return x -> {
            String string;
            Object patt0$temp = x.arg();
            if (patt0$temp instanceof Class) {
                Class c = (Class)patt0$temp;
                string = x.negated() ? x.name() + " must not be an array type (was " + String.valueOf(ArrayInfo.create(c)) + ")" : x.name() + " must be an array type (was " + MsgUtil.className(c) + ")";
            } else {
                string = x.negated() ? x.name() + " must not be an array (was " + ArrayInfo.describe(x.arg()) + ")" : x.name() + " must be an array (was " + MsgUtil.toStr(x.arg()) + ")";
            }
            return string;
        };
    }

    static PrefabMsgFormatter msgRegularFile() {
        return x -> x.negated() ? x.name() + " must not be an existing, regular file (was " + String.valueOf(x.arg()) + ")" : "no such file: " + String.valueOf(x.arg());
    }

    static PrefabMsgFormatter msgDirectory() {
        return x -> x.negated() ? x.name() + " must not be an existing directory (was " + String.valueOf(x.arg()) + ")" : "no such directory: " + String.valueOf(x.arg());
    }

    static PrefabMsgFormatter msgSymlink() {
        return x -> x.negated() ? x.name() + " must not be a symbolic link (was " + String.valueOf(x.arg()) + ")" : x.name() + " must be a symbolic link (was " + String.valueOf(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgFileExists() {
        return x -> x.negated() ? x.name() + " must not exist (was " + String.valueOf(x.arg()) + ")" : "file not found: " + String.valueOf(x.arg());
    }

    static PrefabMsgFormatter msgReadable() {
        return x -> x.negated() ? x.name() + " must not be readable (was " + String.valueOf(x.arg()) + ")" : x.name() + " must be readable (was " + String.valueOf(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgWritable() {
        return x -> x.negated() ? x.name() + " must not be writable (was " + String.valueOf(x.arg()) + ")" : x.name() + " must be writable (was " + String.valueOf(x.arg()) + ")";
    }

    static PrefabMsgFormatter msgPresent() {
        return x -> x.negated() ? "Optional " + x.name() + " must be empty (was " + MsgUtil.toStr(x.arg()) + ")" : "Optional " + x.name() + " must not be empty";
    }

    static PrefabMsgFormatter msgAvailable() {
        return x -> x.negated() ? "Result " + x.name() + " must not be available (was " + MsgUtil.toStr(x.arg()) + ")" : "No result available for " + x.name();
    }
}

