/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x.msg;

import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.klojang.check.x.Misc;
import org.klojang.check.x.msg.CheckDefs;
import org.klojang.check.x.msg.MsgUtil;

public final class CustomMsgFormatter {
    private static final String ARG_START = "${";
    private static final char ARG_END = '}';
    private static final String REGEX = "\\$\\{(tag|arg|obj|type|test|\\d+)}";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(tag|arg|obj|type|test|\\d+)}");
    private static final Map<String, Function<Object[], String>> ARG_LOOKUPS = Map.of("test", CustomMsgFormatter::getCheck, "arg", args -> Misc.toShortString(args[1], 65), "type", CustomMsgFormatter::getType, "tag", CustomMsgFormatter::getTag, "obj", args -> Misc.toShortString(args[4], 65));

    private CustomMsgFormatter() {
    }

    static String format(String msg, Object[] msgArgs) {
        int x = msg.indexOf(ARG_START);
        if (x == -1) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg.length() + 20);
        int y = 0;
        do {
            sb.append(msg, y, x);
            y = msg.indexOf(125, x += 2);
            if (y == -1) {
                return sb.append(ARG_START).append(msg, x, msg.length()).toString();
            }
            sb.append(CustomMsgFormatter.getArgVal(msg.substring(x, y), msgArgs));
        } while ((x = msg.indexOf(ARG_START, ++y)) != -1);
        return sb.append(msg, y, msg.length()).toString();
    }

    static String formatWithPrefabArgs(String msg, Object[] msgArgs) {
        int x = msg.indexOf(ARG_START);
        if (x == -1) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg.length() + 20);
        int y = 0;
        do {
            sb.append(msg, y, x);
            y = msg.indexOf(125, x += 2);
            if (y == -1) {
                return sb.append(ARG_START).append(msg, x, msg.length()).toString();
            }
            sb.append(CustomMsgFormatter.getPrefabArgVal(msg.substring(x, y), msgArgs));
        } while ((x = msg.indexOf(ARG_START, ++y)) != -1);
        return sb.append(msg, y, msg.length()).toString();
    }

    public static String formatWithUserArgs(String msg, Object[] msgArgs) {
        int x = msg.indexOf(ARG_START);
        if (x == -1) {
            return msg;
        }
        StringBuilder out = new StringBuilder(msg.length() + 20);
        int y = 0;
        do {
            out.append(msg, y, x);
            y = msg.indexOf(125, x += 2);
            if (y == -1) {
                return out.append(ARG_START).append(msg, x, msg.length()).toString();
            }
            out.append(CustomMsgFormatter.getUserArgVal(msg.substring(x, y), msgArgs));
        } while ((x = msg.indexOf(ARG_START, ++y)) != -1);
        return out.append(msg, y, msg.length()).toString();
    }

    private static String getArgVal(String arg, Object[] args) {
        Function<Object[], String> fnc = ARG_LOOKUPS.get(arg);
        if (fnc != null) {
            return fnc.apply(args);
        }
        try {
            int i = 5 + new BigInteger(arg).intValueExact();
            if (i < args.length) {
                return Objects.toString(args[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ARG_START + arg + "}";
    }

    private static String getPrefabArgVal(String arg, Object[] args) {
        Function<Object[], String> fnc = ARG_LOOKUPS.get(arg);
        if (fnc != null) {
            return fnc.apply(args);
        }
        return ARG_START + arg + "}";
    }

    private static String getUserArgVal(String arg, Object[] args) {
        try {
            int i = new BigInteger(arg).intValueExact();
            if (i >= 0 && i < args.length) {
                return Objects.toString(args[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ARG_START + arg + "}";
    }

    private static String getCheck(Object[] args) {
        String name = CheckDefs.nameOf(args[0]);
        if (name != null) {
            return name;
        }
        return args[0].getClass().getSimpleName();
    }

    private static String getTag(Object[] args) {
        if (args[3] == null) {
            return "argument";
        }
        return args[3].toString();
    }

    private static String getType(Object[] args) {
        if (args[2] == null) {
            if (args[1] != null) {
                return Misc.describe(args[1]);
            }
            return null;
        }
        return MsgUtil.simpleClassName(args[2]);
    }
}

