/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x.msg;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.klojang.check.CommonChecks;
import org.klojang.check.relation.ComposableIntPredicate;
import org.klojang.check.relation.IntObjRelation;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Relation;
import org.klojang.check.x.msg.MsgArgs;
import org.klojang.check.x.msg.MsgIntObjRelation;
import org.klojang.check.x.msg.MsgIntPredicate;
import org.klojang.check.x.msg.MsgIntRelation;
import org.klojang.check.x.msg.MsgObjIntRelation;
import org.klojang.check.x.msg.MsgPredicate;
import org.klojang.check.x.msg.MsgRelation;
import org.klojang.check.x.msg.PrefabMsgFormatter;

public final class CheckDefs {
    private static final Map<Predicate<?>, Function<MsgArgs, String>> predicateFormatters;
    private static final Map<IntPredicate, Function<MsgArgs, String>> intPredicateFormatters;
    private static final Map<Relation<?, ?>, Function<MsgArgs, String>> relationFormatters;
    private static final Map<IntRelation, Function<MsgArgs, String>> intRelationFormatters;
    private static final Map<IntObjRelation<?>, Function<MsgArgs, String>> intObjRelationFormatters;
    private static final Map<Object, String> names;
    private static Map<Predicate<?>, Function<MsgArgs, String>> predicateFormattersTemp;
    private static Map<ComposableIntPredicate, Function<MsgArgs, String>> intPredicateFormattersTemp;
    private static Map<Relation<?, ?>, Function<MsgArgs, String>> relationFormattersTemp;
    private static Map<IntRelation, Function<MsgArgs, String>> intRelationFormattersTemp;
    private static Map<IntObjRelation<?>, Function<MsgArgs, String>> intObjRelationFormattersTemp;
    private static Map<Object, String> namesTemp;

    public static String nameOf(Object check) {
        return names.get(check);
    }

    public static Function<MsgArgs, String> getPredicateFormatter(Predicate<?> predicate) {
        return predicateFormatters.get(predicate);
    }

    public static Function<MsgArgs, String> getIntPredicateFormatter(IntPredicate predicate) {
        return intPredicateFormatters.get(predicate);
    }

    public static Function<MsgArgs, String> getRelationFormatter(Relation<?, ?> relation) {
        return relationFormatters.get(relation);
    }

    public static Function<MsgArgs, String> getIntRelationFormatter(IntRelation relation) {
        return intRelationFormatters.get(relation);
    }

    public static Function<MsgArgs, String> getIntObjRelationFormatter(IntObjRelation<?> relation) {
        return intObjRelationFormatters.get(relation);
    }

    private static void setMetadata(Predicate<?> check, PrefabMsgFormatter formatter, String name) {
        predicateFormattersTemp.put(check, formatter);
        namesTemp.put(check, name);
    }

    private static void setMetadata(ComposableIntPredicate check, PrefabMsgFormatter formatter, String name) {
        intPredicateFormattersTemp.put(check, formatter);
        namesTemp.put(check, name);
    }

    private static void setMetadata(Relation<?, ?> check, PrefabMsgFormatter formatter, String name) {
        relationFormattersTemp.put(check, formatter);
        namesTemp.put(check, name);
    }

    private static void setMetadata(IntRelation check, PrefabMsgFormatter formatter, String name) {
        intRelationFormattersTemp.put(check, formatter);
        namesTemp.put(check, name);
    }

    private static void setMetadata(IntObjRelation<?> check, PrefabMsgFormatter formatter, String name) {
        intObjRelationFormattersTemp.put(check, formatter);
        namesTemp.put(check, name);
    }

    static {
        predicateFormattersTemp = new HashMap();
        intPredicateFormattersTemp = new HashMap<ComposableIntPredicate, Function<MsgArgs, String>>();
        relationFormattersTemp = new HashMap();
        intRelationFormattersTemp = new HashMap<IntRelation, Function<MsgArgs, String>>();
        intObjRelationFormattersTemp = new HashMap();
        namesTemp = new HashMap<Object, String>();
        CheckDefs.setMetadata(CommonChecks.NULL(), MsgPredicate.msgNull(), "NULL");
        CheckDefs.setMetadata(CommonChecks.notNull(), MsgPredicate.msgNotNull(), "notNull");
        CheckDefs.setMetadata(CommonChecks.yes(), MsgPredicate.msgYes(), "yes");
        CheckDefs.setMetadata(CommonChecks.no(), MsgPredicate.msgNo(), "no");
        CheckDefs.setMetadata(CommonChecks.empty(), MsgPredicate.msgEmpty(), "empty");
        CheckDefs.setMetadata(CommonChecks.emptyString(), MsgPredicate.msgEmpty(), "emptyString");
        CheckDefs.setMetadata(CommonChecks.notEmpty(), MsgPredicate.msgNotEmpty(), "notEmpty");
        CheckDefs.setMetadata(CommonChecks.deepNotNull(), MsgPredicate.msgDeepNotNull(), "deepNotNull");
        CheckDefs.setMetadata(CommonChecks.deepNotEmpty(), MsgPredicate.msgDeepNotEmpty(), "deepNotEmpty");
        CheckDefs.setMetadata(CommonChecks.blank(), MsgPredicate.msgBlank(), "blank");
        CheckDefs.setMetadata(CommonChecks.plainInt(), MsgPredicate.msgPlainInt(), "plainInt");
        CheckDefs.setMetadata(CommonChecks.plainShort(), MsgPredicate.msgPlainShort(), "plainShort");
        CheckDefs.setMetadata(CommonChecks.array(), MsgPredicate.msgArray(), "array");
        CheckDefs.setMetadata(CommonChecks.regularFile(), MsgPredicate.msgRegularFile(), "regularFile");
        CheckDefs.setMetadata(CommonChecks.directory(), MsgPredicate.msgDirectory(), "directory");
        CheckDefs.setMetadata(CommonChecks.symlink(), MsgPredicate.msgSymlink(), "symlink");
        CheckDefs.setMetadata(CommonChecks.fileExists(), MsgPredicate.msgFileExists(), "fileExists");
        CheckDefs.setMetadata(CommonChecks.readable(), MsgPredicate.msgReadable(), "readable");
        CheckDefs.setMetadata(CommonChecks.writable(), MsgPredicate.msgWritable(), "writable");
        CheckDefs.setMetadata(CommonChecks.present(), MsgPredicate.msgPresent(), "present");
        CheckDefs.setMetadata(CommonChecks.available(), MsgPredicate.msgAvailable(), "available");
        CheckDefs.setMetadata(CommonChecks.even(), MsgIntPredicate.msgEven(), "even");
        CheckDefs.setMetadata(CommonChecks.odd(), MsgIntPredicate.msgOdd(), "odd");
        CheckDefs.setMetadata(CommonChecks.positive(), MsgIntPredicate.msgPositive(), "positive");
        CheckDefs.setMetadata(CommonChecks.negative(), MsgIntPredicate.msgNegative(), "negative");
        CheckDefs.setMetadata(CommonChecks.zero(), MsgIntPredicate.msgZero(), "zero");
        CheckDefs.setMetadata(CommonChecks.eq(), MsgIntRelation.msgEq(), "eq");
        CheckDefs.setMetadata(CommonChecks.ne(), MsgIntRelation.msgNe(), "ne");
        CheckDefs.setMetadata(CommonChecks.gt(), MsgIntRelation.msgGt(), "gt");
        CheckDefs.setMetadata(CommonChecks.gte(), MsgIntRelation.msgGte(), "gte");
        CheckDefs.setMetadata(CommonChecks.lt(), MsgIntRelation.msgLt(), "lt");
        CheckDefs.setMetadata(CommonChecks.lte(), MsgIntRelation.msgLte(), "lte");
        CheckDefs.setMetadata(CommonChecks.multipleOf(), MsgIntRelation.msgMultipleOf(), "multipleOf");
        CheckDefs.setMetadata(CommonChecks.EQ(), MsgObjIntRelation.msgEQ(), "EQ");
        CheckDefs.setMetadata(CommonChecks.equalTo(), MsgObjIntRelation.msgEQ(), "equalTo");
        CheckDefs.setMetadata(CommonChecks.GT(), MsgObjIntRelation.msgGT(), "GT");
        CheckDefs.setMetadata(CommonChecks.LT(), MsgObjIntRelation.msgLT(), "LT");
        CheckDefs.setMetadata(CommonChecks.GTE(), MsgObjIntRelation.msgGTE(), "GTE");
        CheckDefs.setMetadata(CommonChecks.LTE(), MsgObjIntRelation.msgLTE(), "LTE");
        CheckDefs.setMetadata(CommonChecks.sameAs(), MsgRelation.msgSameAs(), "sameAs");
        CheckDefs.setMetadata(CommonChecks.nullOr(), MsgRelation.msgNullOr(), "nullOr");
        CheckDefs.setMetadata(CommonChecks.instanceOf(), MsgRelation.msgInstanceOf(), "instanceOf");
        CheckDefs.setMetadata(CommonChecks.supertypeOf(), MsgRelation.msgSupertypeOf(), "supertypeOf");
        CheckDefs.setMetadata(CommonChecks.subtypeOf(), MsgRelation.msgSubtypeOf(), "subtypeOf");
        CheckDefs.setMetadata(CommonChecks.contains(), MsgRelation.msgContains(), "contains");
        CheckDefs.setMetadata(CommonChecks.containsKey(), MsgRelation.msgContainsKey(), "containsKey");
        CheckDefs.setMetadata(CommonChecks.containsValue(), MsgRelation.msgContainsValue(), "containsValue");
        CheckDefs.setMetadata(CommonChecks.in(), MsgRelation.msgIn(), "in");
        CheckDefs.setMetadata(CommonChecks.keyIn(), MsgRelation.msgKeyIn(), "keyIn");
        CheckDefs.setMetadata(CommonChecks.valueIn(), MsgRelation.msgValueIn(), "valueIn");
        CheckDefs.setMetadata(CommonChecks.inArray(), MsgRelation.msgIn(), "inArray");
        CheckDefs.setMetadata(CommonChecks.containsAll(), MsgRelation.msgContainsAll(), "containsAll");
        CheckDefs.setMetadata(CommonChecks.containedIn(), MsgRelation.msgContainedIn(), "containedIn");
        CheckDefs.setMetadata(CommonChecks.hasSubstring(), MsgRelation.msgHasSubstring(), "hasSubstring");
        CheckDefs.setMetadata(CommonChecks.hasSubstringIC(), MsgRelation.msgHasSubstringIC(), "hasSubstringIC");
        CheckDefs.setMetadata(CommonChecks.substringOf(), MsgRelation.msgSubstringOf(), "substringOf");
        CheckDefs.setMetadata(CommonChecks.equalsIC(), MsgRelation.msgEqualsIC(), "equalsIC");
        CheckDefs.setMetadata(CommonChecks.startsWith(), MsgRelation.msgStartsWith(), "startsWith");
        CheckDefs.setMetadata(CommonChecks.startsWithIC(), MsgRelation.msgStartsWithIC(), "startsWithIC");
        CheckDefs.setMetadata(CommonChecks.endsWith(), MsgRelation.msgEndsWith(), "endsWith");
        CheckDefs.setMetadata(CommonChecks.endsWithIC(), MsgRelation.msgEndsWithIC(), "endsWithIC");
        CheckDefs.setMetadata(CommonChecks.hasPattern(), MsgRelation.msgHasPattern(), "hasPattern");
        CheckDefs.setMetadata(CommonChecks.containsPattern(), MsgRelation.msgContainsPattern(), "containsPattern");
        CheckDefs.setMetadata(CommonChecks.matches(), MsgRelation.msgHasPattern(), "matches");
        CheckDefs.setMetadata(CommonChecks.containsMatch(), MsgRelation.msgContainsPattern(), "containsMatch");
        CheckDefs.setMetadata(CommonChecks.numerical(), MsgRelation.msgNumerical(), "numerical");
        CheckDefs.setMetadata(CommonChecks.parsableAs(), MsgRelation.msgParsableAs(), "parsableAs");
        CheckDefs.setMetadata(CommonChecks.indexOf(), MsgIntObjRelation.msgIndexOf(), "indexOf");
        CheckDefs.setMetadata(CommonChecks.indexInclusiveOf(), MsgIntObjRelation.msgIndexInclusiveInto(), "indexInclusiveInto");
        CheckDefs.setMetadata(CommonChecks.inIntArray(), MsgRelation.msgIn(), "inIntArray");
        predicateFormatters = Map.copyOf(predicateFormattersTemp);
        intPredicateFormatters = Map.copyOf(intPredicateFormattersTemp);
        relationFormatters = Map.copyOf(relationFormattersTemp);
        intRelationFormatters = Map.copyOf(intRelationFormattersTemp);
        intObjRelationFormatters = Map.copyOf(intObjRelationFormattersTemp);
        names = Map.copyOf(namesTemp);
        predicateFormattersTemp = null;
        intPredicateFormattersTemp = null;
        relationFormattersTemp = null;
        intRelationFormattersTemp = null;
        intObjRelationFormattersTemp = null;
        namesTemp = null;
    }
}

