/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Predicate;

public final class StringCheckImpls {
    private static final BigDecimal MIN_DOUBLE_BD = new BigDecimal(Double.toString(Double.MIN_VALUE));
    private static final BigDecimal MAX_DOUBLE_BD = new BigDecimal(Double.toString(Double.MAX_VALUE));
    private static final BigDecimal MIN_FLOAT_BD = new BigDecimal(Float.toString(Float.MIN_VALUE));
    private static final BigDecimal MAX_FLOAT_BD = new BigDecimal(Float.toString(Float.MAX_VALUE));
    public static final Map<Class<?>, Predicate<String>> NUMERICALS = Map.of(Long.TYPE, StringCheckImpls::isLongExact, Integer.TYPE, StringCheckImpls::isIntExact, Short.TYPE, StringCheckImpls::isShortExact, Byte.TYPE, StringCheckImpls::isByteExact, Double.TYPE, StringCheckImpls::isDouble, Float.TYPE, StringCheckImpls::isFloat);
    private static final BigDecimal MIN_LONG_BD = new BigDecimal(Long.MIN_VALUE);
    private static final BigDecimal MAX_LONG_BD = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal MIN_INT_BD = new BigDecimal(Integer.MIN_VALUE);
    private static final BigDecimal MAX_INT_BD = new BigDecimal(Integer.MAX_VALUE);
    private static final BigDecimal MIN_SHORT_BD = new BigDecimal(Short.MIN_VALUE);
    private static final BigDecimal MAX_SHORT_BD = new BigDecimal(Short.MAX_VALUE);
    private static final BigDecimal MIN_BYTE_BD = new BigDecimal(-128);
    private static final BigDecimal MAX_BYTE_BD = new BigDecimal(127);
    public static final Map<Class<?>, Predicate<String>> PARSABLES = Map.of(Integer.TYPE, StringCheckImpls::isInt, Long.TYPE, StringCheckImpls::isLong, Short.TYPE, StringCheckImpls::isShort, Byte.TYPE, StringCheckImpls::isByte, Double.TYPE, StringCheckImpls::isDouble, Float.TYPE, StringCheckImpls::isFloat);
    private static final int MAX_INT_STR_LEN = String.valueOf(Integer.MAX_VALUE).length();
    private static final int MAX_SHORT_STR_LEN = String.valueOf(Short.MAX_VALUE).length();

    private StringCheckImpls() {
        throw new UnsupportedOperationException();
    }

    private static boolean isLongExact(String s) {
        return StringCheckImpls.isExact(s, 63);
    }

    private static boolean isIntExact(String s) {
        return StringCheckImpls.isExact(s, 31);
    }

    private static boolean isShortExact(String s) {
        return StringCheckImpls.isExact(s, 15);
    }

    private static boolean isByteExact(String s) {
        return StringCheckImpls.isExact(s, 7);
    }

    private static boolean isLong(String s) {
        return StringCheckImpls.parsable(s, MIN_LONG_BD, MAX_LONG_BD);
    }

    private static boolean isInt(String s) {
        return StringCheckImpls.parsable(s, MIN_INT_BD, MAX_INT_BD);
    }

    private static boolean isShort(String s) {
        return StringCheckImpls.parsable(s, MIN_SHORT_BD, MAX_SHORT_BD);
    }

    private static boolean isByte(String s) {
        return StringCheckImpls.parsable(s, MIN_BYTE_BD, MAX_BYTE_BD);
    }

    private static boolean isDouble(String s) {
        if (!s.isEmpty()) {
            BigDecimal bd;
            try {
                bd = new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return bd.equals(BigDecimal.ZERO) || (bd = bd.abs()).compareTo(MIN_DOUBLE_BD) >= 0 && bd.compareTo(MAX_DOUBLE_BD) <= 0;
        }
        return false;
    }

    private static boolean isFloat(String s) {
        if (!s.isEmpty()) {
            BigDecimal bd;
            try {
                bd = new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return bd.equals(BigDecimal.ZERO) || (bd = bd.abs()).compareTo(MIN_FLOAT_BD) >= 0 && bd.compareTo(MAX_FLOAT_BD) <= 0;
        }
        return false;
    }

    private static boolean isRound(BigDecimal bd) {
        return bd.scale() <= 0 || bd.stripTrailingZeros().scale() == 0 || bd.divideToIntegralValue(BigDecimal.ONE).compareTo(bd) == 0;
    }

    public static boolean isPlainInt(String s) {
        return StringCheckImpls.isPlain(s, MAX_INT_STR_LEN, 31);
    }

    public static boolean isPlainShort(String s) {
        return StringCheckImpls.isPlain(s, MAX_SHORT_STR_LEN, 15);
    }

    private static boolean isPlain(String s, int maxStrLen, int maxBitLen) {
        if (s.isEmpty() || s.length() > maxStrLen) {
            return false;
        }
        if (s.charAt(0) == '0') {
            return s.length() == 1;
        }
        char c = s.charAt(0);
        if (c < '0' || c > '9') {
            return false;
        }
        try {
            return new BigInteger(s).bitLength() <= maxBitLen;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isExact(String s, int bitLength) {
        if (!s.isEmpty()) {
            try {
                return new BigInteger(s).bitLength() <= bitLength;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean parsable(String s, BigDecimal min, BigDecimal max) {
        if (!s.isEmpty()) {
            try {
                BigDecimal bd = new BigDecimal(s);
                return StringCheckImpls.isRound(bd) && bd.compareTo(min) >= 0 && bd.compareTo(max) <= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

