/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.klojang.check.CorruptCheckException;
import org.klojang.check.x.ArrayInfo;

public final class Misc {
    private static final String SEP = ", ";

    private Misc() {
        throw new UnsupportedOperationException();
    }

    public static int getArrayLength(Object array) {
        try {
            return MethodHandles.arrayLength(array.getClass()).invoke(array);
        }
        catch (Throwable t) {
            throw new CorruptCheckException(t.toString());
        }
    }

    public static String describe(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass() == Class.class) {
            return Misc.simpleClassName((Class)obj) + ".class";
        }
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            return c.getClass().getSimpleName() + "[" + c.size() + "]";
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            return m.getClass().getSimpleName() + "[" + m.size() + "]";
        }
        if (obj.getClass().isArray()) {
            return ArrayInfo.describe(obj);
        }
        return obj.getClass().getSimpleName();
    }

    public static String toShortString(Object obj, int maxWidth) {
        int maxElements = Misc.divUp(maxWidth, 8);
        int maxEntries = Misc.divUp(maxWidth, 16);
        return Misc.toShortString(obj, maxWidth, maxElements, maxEntries);
    }

    static String toShortString(Object obj, int maxLen, int maxElems, int maxEntries) {
        String s;
        if (obj == null) {
            return "null";
        }
        if (obj.getClass() == String.class || obj.getClass() == Integer.class) {
            return Misc.ellipsis(obj.toString(), maxLen);
        }
        if (obj.getClass() == Class.class) {
            s = Misc.simpleClassName((Class)obj);
        } else if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            Stringifier stringifier = o -> Misc.toShortString(o, maxLen, maxElems, maxEntries);
            s = Misc.delimit0(Misc.implodeCollection(c, stringifier, maxElems), c.size(), maxElems);
        } else if (obj instanceof Map) {
            Map m = (Map)obj;
            Stringifier stringifier = o -> Misc.toShortString(o, maxLen, maxElems, maxEntries);
            s = Misc.delimit1(Misc.implodeCollection(m.entrySet(), stringifier, maxElems), m.size(), maxElems);
        } else if (obj instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)obj;
            s = Misc.entryToString(e, maxLen, maxElems, maxEntries);
        } else if (obj.getClass() == int[].class) {
            int[] ints = (int[])obj;
            s = Misc.delimit0(Misc.implodeInts(ints, maxElems), ints.length, maxElems);
        } else if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            Stringifier stringifier = o -> Misc.toShortString(o, maxLen, maxElems, maxEntries);
            s = Misc.delimit0(Misc.implodeArray(objs, stringifier, maxElems), objs.length, maxElems);
        } else if (obj.getClass().isArray()) {
            Stringifier stringifier = o -> Misc.toShortString(o, maxLen, maxElems, maxEntries);
            s = Misc.delimit0(Misc.implodeAny(obj, stringifier, maxElems), Misc.getArrayLength(obj), maxElems);
        } else {
            s = obj.toString();
        }
        return Misc.ellipsis(s, maxLen);
    }

    private static String delimit0(String imploded, int len, int maxElems) {
        if (len == 0) {
            return "[]";
        }
        Object suffix = len <= maxElems ? "]" : " (+" + (len - maxElems) + ")]";
        return "[" + imploded + (String)suffix;
    }

    private static String delimit1(String imploded, int len, int maxElems) {
        if (len == 0) {
            return "{}";
        }
        Object suffix = len <= maxElems ? "}" : " (+" + (len - maxElems) + ")}";
        return "{" + imploded + (String)suffix;
    }

    public static String ellipsis(String str, int maxWidth) {
        if (str.length() <= maxWidth) {
            return str;
        }
        int newLen = Math.max(1, maxWidth - 3);
        return str.substring(0, newLen) + "...";
    }

    public static String simpleClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return ArrayInfo.create(clazz).simpleName();
        }
        return clazz.getSimpleName();
    }

    public static String className(Class<?> clazz) {
        if (clazz.isArray()) {
            return ArrayInfo.create(clazz).name();
        }
        return clazz.getName();
    }

    private static String entryToString(Map.Entry<?, ?> e, int maxLen, int maxElems, int maxEntries) {
        String k = Misc.toShortString(e.getKey(), maxLen, maxElems, maxEntries);
        String v = Misc.toShortString(e.getValue(), maxLen, maxElems, maxEntries);
        return k + "=" + v;
    }

    private static <T> String implodeCollection(Collection<T> collection, Stringifier stringifier, int maxElems) {
        int x = Math.min(collection.size(), maxElems);
        return collection.stream().limit(x).map(stringifier).collect(Collectors.joining(SEP));
    }

    private static <T> String implodeArray(T[] array, Stringifier stringifier, int maxElems) {
        int x = Math.min(array.length, maxElems);
        return Arrays.stream(array, 0, x).map(stringifier).collect(Collectors.joining(SEP));
    }

    private static String implodeInts(int[] array, int maxElems) {
        int x = Math.min(array.length, maxElems);
        return Arrays.stream(array, 0, x).mapToObj(String::valueOf).collect(Collectors.joining(SEP));
    }

    public static String implodeAny(Object array, Stringifier stringifier, int to) {
        int len = Misc.getArrayLength(array);
        int x = Math.min(to, len);
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < x; ++i) {
                if (i != 0) {
                    sb.append(SEP);
                }
                Object o = Misc.getArrayElement(array, i);
                sb.append((String)stringifier.apply(o));
            }
        }
        catch (Throwable t) {
            throw new CorruptCheckException(t.toString());
        }
        return sb.toString();
    }

    private static <T> T getArrayElement(Object array, int idx) throws Throwable {
        return (T)MethodHandles.arrayElementGetter(array.getClass()).invoke(array, idx);
    }

    private static int divUp(int value, int divideBy) {
        return (int)Math.ceil((double)value / (double)divideBy);
    }

    public static CorruptCheckException typeNotSupported(Class<?> type) {
        return new CorruptCheckException("type not supported: " + String.valueOf(type));
    }

    public static CorruptCheckException notApplicable(String check, Object arg) {
        String msg = String.format("%s not applicable to %s", check, arg.getClass());
        return new CorruptCheckException(msg);
    }

    private static interface Stringifier
    extends Function<Object, String> {
    }
}

