/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.klojang.check.CorruptCheckException;
import org.klojang.check.aux.Emptyable;
import org.klojang.check.x.Misc;

public final class CheckImpls {
    private static final Set<Class<?>> NULL_REPELLERS = Set.copyOf(new HashSet<Class>(Arrays.asList(Collections.emptyList().getClass(), Collections.emptySet().getClass(), List.of().getClass(), List.of(Integer.valueOf(1)).getClass(), List.of(Integer.valueOf(1), Integer.valueOf(2)).getClass(), List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)).getClass(), Set.of().getClass(), Set.of(Integer.valueOf(1)).getClass(), Set.of(Integer.valueOf(1), Integer.valueOf(2)).getClass(), Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)).getClass())));
    private static final Set<Class<?>> NULL_REPELLENT_MAPS = Set.copyOf(new HashSet<Class>(Arrays.asList(Collections.emptyMap().getClass(), Map.of().getClass(), Map.of(1, Character.valueOf('a')).getClass(), Map.of(1, Character.valueOf('a'), 2, Character.valueOf('b')).getClass(), Map.of(1, Character.valueOf('a'), 2, Character.valueOf('b'), 3, Character.valueOf('c')).getClass())));

    public static <T> boolean isEmpty(T arg) {
        File f;
        Emptyable e;
        Optional o;
        Object[] x;
        Map m;
        Collection c;
        CharSequence cs;
        return arg == null || arg instanceof CharSequence && (cs = (CharSequence)arg).length() == 0 || arg instanceof Collection && (c = (Collection)arg).size() == 0 || CheckImpls.isArray(arg) && Misc.getArrayLength(arg) == 0 || arg instanceof Map && (m = (Map)arg).size() == 0 || arg instanceof Object[] && (x = (Object[])arg).length == 0 || arg instanceof Optional && ((o = (Optional)arg).isEmpty() || CheckImpls.isEmpty(o.get())) || arg instanceof Emptyable && (e = (Emptyable)arg).isEmpty() || arg instanceof File && CheckImpls.fileSize(f = (File)arg) == 0L;
    }

    public static <T> boolean isNotEmpty(T arg) {
        File f;
        Emptyable e;
        Optional o;
        Object[] x;
        Map m;
        Collection c;
        CharSequence cs;
        return !(arg == null || arg instanceof CharSequence && (cs = (CharSequence)arg).length() == 0 || arg instanceof Collection && (c = (Collection)arg).size() == 0 || CheckImpls.isArray(arg) && Misc.getArrayLength(arg) == 0 || arg instanceof Map && (m = (Map)arg).size() == 0 || arg instanceof Object[] && (x = (Object[])arg).length == 0 || arg instanceof Optional && (!(o = (Optional)arg).isPresent() || !CheckImpls.isNotEmpty(o.get())) || arg instanceof Emptyable && (e = (Emptyable)arg).isEmpty() || arg instanceof File && CheckImpls.fileSize(f = (File)arg) == 0L);
    }

    public static boolean isDeepNotEmpty(Object arg) {
        File f;
        Emptyable e;
        Optional o;
        Object[] x;
        Map m;
        Collection c;
        CharSequence cs;
        return !(arg == null || arg instanceof CharSequence && (cs = (CharSequence)arg).length() <= 0 || arg instanceof Collection && !CheckImpls.dne(c = (Collection)arg) || CheckImpls.isArray(arg) && Misc.getArrayLength(arg) == 0 || arg instanceof Map && !CheckImpls.dne(m = (Map)arg) || arg instanceof Object[] && !CheckImpls.dne(x = (Object[])arg) || arg instanceof Optional && !CheckImpls.dne(o = (Optional)arg) || arg instanceof Emptyable && !(e = (Emptyable)arg).isDeepNotEmpty() || arg instanceof File && !CheckImpls.isBlankFile(f = (File)arg));
    }

    public static boolean isDeepNotNull(Object arg) {
        if (arg == null) {
            return false;
        }
        if (arg instanceof Object[]) {
            Object[] o = (Object[])arg;
            return Arrays.stream(o).allMatch(Objects::nonNull);
        }
        if (arg instanceof Collection) {
            Collection c = (Collection)arg;
            return CheckImpls.isNullRepellent(c) || c.stream().allMatch(Objects::nonNull);
        }
        if (arg instanceof Map) {
            Map m = (Map)arg;
            return CheckImpls.isNullRepellent(m) || m.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null);
        }
        return true;
    }

    public static <T, U extends T> boolean inArray(U elem, T[] array) {
        if (elem == null) {
            for (T e : array) {
                if (e != null) continue;
                return true;
            }
        } else {
            for (T e : array) {
                if (!elem.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isIndexOf(int idx, T obj) {
        if (idx < 0) {
            return false;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return idx < s.length();
        }
        if (obj instanceof List) {
            List l = (List)obj;
            return idx < l.size();
        }
        if (obj.getClass().isArray()) {
            try {
                return idx < Misc.getArrayLength(obj);
            }
            catch (Throwable t) {
                throw new CorruptCheckException(t.toString());
            }
        }
        throw Misc.notApplicable("indexOf", obj.getClass());
    }

    public static <T> boolean isIndexInclusiveOf(int idx, T obj) {
        if (idx < 0) {
            return false;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return idx <= s.length();
        }
        if (obj instanceof List) {
            List l = (List)obj;
            return idx <= l.size();
        }
        if (obj.getClass().isArray()) {
            try {
                return idx <= Misc.getArrayLength(obj);
            }
            catch (Throwable t) {
                throw new CorruptCheckException(t.toString());
            }
        }
        throw Misc.notApplicable("indexInclusiveOf", obj.getClass());
    }

    private static boolean dne(Collection<?> coll) {
        if (coll.isEmpty()) {
            return false;
        }
        return coll.stream().allMatch(CheckImpls::isDeepNotEmpty);
    }

    private static boolean dne(Map<?, ?> map) {
        if (map.isEmpty()) {
            return false;
        }
        return map.entrySet().stream().allMatch(CheckImpls::entryDeepNotEmpty);
    }

    private static boolean entryDeepNotEmpty(Object obj) {
        Map.Entry e = (Map.Entry)obj;
        return CheckImpls.isDeepNotEmpty(e.getKey()) && CheckImpls.isDeepNotEmpty(e.getValue());
    }

    private static boolean dne(Object[] arr) {
        if (arr.length == 0) {
            return false;
        }
        return Arrays.stream(arr).allMatch(CheckImpls::isDeepNotEmpty);
    }

    private static boolean dne(Optional<?> opt) {
        return opt.isPresent() && CheckImpls.isDeepNotEmpty(opt.get());
    }

    private static boolean isNullRepellent(Collection<?> c) {
        return NULL_REPELLERS.contains(c.getClass());
    }

    private static boolean isNullRepellent(Map<?, ?> m) {
        return NULL_REPELLENT_MAPS.contains(m.getClass());
    }

    private static boolean isArray(Object obj) {
        return obj.getClass().isArray();
    }

    private static long fileSize(File f) {
        try {
            return Files.size(f.toPath());
        }
        catch (IOException e) {
            throw new CorruptCheckException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isBlankFile(File f) {
        if (CheckImpls.fileSize(f) == 0L) return true;
        int BUF_SIZE = 128;
        try (FileInputStream in = new FileInputStream(f);
             InputStreamReader isr = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            char[] buf = new char[BUF_SIZE];
            int x = isr.read(buf, 0, BUF_SIZE);
            while (x != -1) {
                for (int y = 0; y < x; ++y) {
                    if (Character.isWhitespace(buf[y])) continue;
                    boolean bl = false;
                    return bl;
                }
                x = isr.read(buf, 0, BUF_SIZE);
            }
            return true;
        }
        catch (IOException e) {
            throw new CorruptCheckException(e.toString());
        }
    }
}

