/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.x;

import org.klojang.check.x.Misc;

public record ArrayInfo(Class<?> baseType, int dimensions) {
    public static ArrayInfo create(Class<?> arrayClass) {
        Class<?> c = arrayClass.getComponentType();
        int i = 1;
        while (c.isArray()) {
            ++i;
            c = c.getComponentType();
        }
        return new ArrayInfo(c, i);
    }

    public static String describe(Object array) {
        ArrayInfo info = ArrayInfo.create(array.getClass());
        int len = Misc.getArrayLength(array);
        StringBuilder sb = new StringBuilder(info.baseType.getSimpleName()).append('[').append(len).append(']');
        for (int i = 1; i < info.dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String name() {
        return this.toString(this.baseType.getName());
    }

    public String simpleName() {
        return this.toString(this.baseType().getSimpleName());
    }

    @Override
    public String toString() {
        return this.simpleName();
    }

    private String toString(String name) {
        if (this.dimensions == 1) {
            return name + "[]";
        }
        StringBuilder sb = new StringBuilder(name.length() + this.dimensions * 2);
        sb.append(name);
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

