/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.relation;

import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.klojang.check.relation.ComposableIntPredicate;
import org.klojang.check.relation.ComposablePredicate;
import org.klojang.check.relation.IntObjRelation;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Relation;

public final class Compose {
    private Compose() {
        throw new UnsupportedOperationException();
    }

    public static <T> ComposablePredicate<T> valid() {
        return x -> true;
    }

    public static ComposableIntPredicate validInt() {
        return x -> true;
    }

    public static <T> ComposablePredicate<T> invalid() {
        return x -> false;
    }

    public static ComposableIntPredicate invalidInt() {
        return x -> false;
    }

    public static <T> ComposablePredicate<T> validIf(T value) {
        return x -> Objects.equals(x, value);
    }

    public static ComposableIntPredicate validIntIf(int value) {
        return x -> x == value;
    }

    public static <T> ComposablePredicate<T> invalidIf(T value) {
        return x -> !Objects.equals(x, value);
    }

    public static ComposableIntPredicate invalidIntIf(int value) {
        return x -> x != value;
    }

    public static <T> ComposablePredicate<T> validWhen(Predicate<T> test) {
        return test::test;
    }

    public static ComposableIntPredicate validIntWhen(IntPredicate test) {
        return test::test;
    }

    public static <S, O> ComposablePredicate<S> validWhen(Relation<S, O> relation, O object) {
        return s -> relation.exists(s, object);
    }

    public static <O> ComposableIntPredicate validIntWhen(IntObjRelation<O> relation, O object) {
        return s -> relation.exists(s, object);
    }

    public static ComposableIntPredicate validIntWhen(IntRelation relation, int object) {
        return s -> relation.exists(s, object);
    }
}

