/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.relation;

import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Private;
import org.klojang.check.relation.Quantifier;
import org.klojang.check.relation.Relation;

@FunctionalInterface
public interface ComposablePredicate<T>
extends Predicate<T> {
    default public ComposablePredicate<T> negated() {
        return x -> !this.meFirst(x);
    }

    default public <V> ComposablePredicate<V> orElse(Predicate<?> test) {
        return x -> this.meFirst(x) || test.test(x);
    }

    default public <O, V> ComposablePredicate<V> orElse(Relation<?, O> relation, O object) {
        return x -> this.meFirst(x) || relation.exists(x, object);
    }

    default public <V> ComposablePredicate<V> orNot(Predicate<?> test) {
        return x -> this.meFirst(x) || !test.test(x);
    }

    default public <O, V> ComposablePredicate<V> orNot(Relation<?, O> relation, O object) {
        return x -> this.meFirst(x) || !relation.exists(x, object);
    }

    default public <O, P extends O, V> ComposablePredicate<V> or(Relation<V, O> relation, Quantifier quantifier, P ... objects) {
        return x -> this.meFirst(x) || Private.testAgainstArray(x, relation, quantifier, objects);
    }

    default public <U, V> ComposablePredicate<V> orThat(U value, Predicate<U> test) {
        return x -> this.meFirst(x) || test.test(value);
    }

    default public <V> ComposablePredicate<V> orThat(int value, IntPredicate test) {
        return x -> this.meFirst(x) || test.test(value);
    }

    default public <S, O, V> ComposablePredicate<V> orThat(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) || relation.exists(subject, object);
    }

    default public <V> ComposablePredicate<V> orThat(int subject, IntRelation relation, int object) {
        return x -> this.meFirst(x) || relation.exists(subject, object);
    }

    default public <U, V> ComposablePredicate<V> orNot(U value, Predicate<U> test) {
        return x -> this.meFirst(x) || !test.test(value);
    }

    default public <S, O, V> ComposablePredicate<V> orNot(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) || !relation.exists(subject, object);
    }

    default public <S, O, P extends O, V> ComposablePredicate<V> or(S subject, Relation<S, O> relation, Quantifier quantifier, P ... objects) {
        return x -> this.meFirst(x) || Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    default public <V> ComposablePredicate<V> or(int subject, IntRelation relation, Quantifier quantifier, int ... objects) {
        return x -> this.meFirst(x) || Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    default public <V> ComposablePredicate<V> or(boolean test) {
        return x -> this.meFirst(x) || test;
    }

    default public <V> ComposablePredicate<V> orEval(Supplier<Boolean> test) {
        return x -> this.meFirst(x) || (Boolean)test.get() != false;
    }

    default public <V> ComposablePredicate<V> andAlso(Predicate<?> test) {
        return x -> this.meFirst(x) && test.test(x);
    }

    default public <O, V> ComposablePredicate<V> andAlso(Relation<?, O> relation, O object) {
        return x -> this.meFirst(x) && relation.exists(x, object);
    }

    default public <V> ComposablePredicate<V> and(boolean test) {
        return x -> this.meFirst(x) && test;
    }

    default public <V> ComposablePredicate<V> andEval(Supplier<Boolean> test) {
        return x -> this.meFirst(x) && (Boolean)test.get() != false;
    }

    default public <V> ComposablePredicate<V> andNot(Predicate<?> test) {
        return x -> this.meFirst(x) && !test.test(x);
    }

    default public <O, V> ComposablePredicate<V> andNot(Relation<?, O> relation, O object) {
        return x -> this.meFirst(x) && !relation.exists(x, object);
    }

    default public <O, P extends O, V> ComposablePredicate<V> and(Relation<V, O> relation, Quantifier quantifier, P ... objects) {
        return x -> this.meFirst(x) && Private.testAgainstArray(x, relation, quantifier, objects);
    }

    default public <U, V> ComposablePredicate<V> andThat(U value, Predicate<U> test) {
        return x -> this.meFirst(x) && test.test(value);
    }

    default public <V> ComposablePredicate<V> andThat(int value, IntPredicate test) {
        return x -> this.meFirst(x) && test.test(value);
    }

    default public <S, O, V> ComposablePredicate<V> andThat(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) && relation.exists(subject, object);
    }

    default public <V> ComposablePredicate<V> andThat(int subject, IntRelation relation, int object) {
        return x -> this.meFirst(x) && relation.exists(subject, object);
    }

    default public <U, V> ComposablePredicate<V> andNot(U value, Predicate<U> test) {
        return x -> this.meFirst(x) && !test.test(value);
    }

    default public <S, O, V> ComposablePredicate<V> andNot(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) && !relation.exists(subject, object);
    }

    default public <S, O, P extends O, V> ComposablePredicate<V> and(S subject, Relation<S, O> relation, Quantifier quantifier, P ... objects) {
        return x -> this.meFirst(x) && Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    default public <V> ComposablePredicate<V> and(int subject, IntRelation relation, Quantifier quantifier, int ... objects) {
        return x -> this.meFirst(x) && Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    private <V> boolean meFirst(V v) {
        return this.test(v);
    }
}

