/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.relation;

import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Private;
import org.klojang.check.relation.Quantifier;
import org.klojang.check.relation.Relation;

@FunctionalInterface
public interface ComposableIntPredicate
extends IntPredicate {
    default public ComposableIntPredicate negated() {
        return x -> !this.meFirst(x);
    }

    default public ComposableIntPredicate orElse(IntPredicate test) {
        return x -> this.meFirst(x) || test.test(x);
    }

    default public ComposableIntPredicate orElse(IntRelation relation, int object) {
        return x -> this.meFirst(x) || relation.exists(x, object);
    }

    default public ComposableIntPredicate orNot(IntPredicate test) {
        return x -> this.meFirst(x) || !test.test(x);
    }

    default public ComposableIntPredicate orNot(IntRelation relation, int object) {
        return x -> this.meFirst(x) || !relation.exists(x, object);
    }

    default public ComposableIntPredicate or(IntRelation relation, Quantifier quantifier, int ... objects) {
        return x -> this.meFirst(x) || Private.testAgainstArray(x, relation, quantifier, objects);
    }

    default public <T> ComposableIntPredicate orThat(T value, Predicate<T> test) {
        return x -> this.meFirst(x) || test.test(value);
    }

    default public ComposableIntPredicate orThat(int value, IntPredicate test) {
        return x -> this.meFirst(x) || test.test(value);
    }

    default public <S, O> ComposableIntPredicate orThat(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) || relation.exists(subject, object);
    }

    default public ComposableIntPredicate orThat(int subject, IntRelation relation, int object) {
        return x -> this.meFirst(x) || relation.exists(subject, object);
    }

    default public <T> ComposableIntPredicate orNot(T value, Predicate<T> test) {
        return x -> this.meFirst(x) || !test.test(value);
    }

    default public ComposableIntPredicate orNot(int value, IntPredicate test) {
        return x -> this.meFirst(x) || !test.test(value);
    }

    default public <S, O> ComposableIntPredicate orNot(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) || !relation.exists(subject, object);
    }

    default public <S, O, P extends O> ComposableIntPredicate or(S subject, Relation<S, O> relation, Quantifier quantifier, P ... objects) {
        return x -> this.meFirst(x) || Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    default public ComposableIntPredicate or(int subject, IntRelation relation, Quantifier quantifier, int ... objects) {
        return x -> this.meFirst(x) || Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    default public ComposableIntPredicate or(boolean test) {
        return x -> this.meFirst(x) || test;
    }

    default public ComposableIntPredicate orEval(Supplier<Boolean> test) {
        return x -> this.meFirst(x) || (Boolean)test.get() != false;
    }

    default public ComposableIntPredicate andAlso(IntPredicate test) {
        return x -> this.meFirst(x) && test.test(x);
    }

    default public ComposableIntPredicate andAlso(IntRelation relation, int object) {
        return x -> this.meFirst(x) && relation.exists(x, object);
    }

    default public ComposableIntPredicate and(boolean test) {
        return x -> this.meFirst(x) && test;
    }

    default public ComposableIntPredicate andEval(Supplier<Boolean> test) {
        return x -> this.meFirst(x) && (Boolean)test.get() != false;
    }

    default public ComposableIntPredicate andNot(IntPredicate test) {
        return x -> this.meFirst(x) && !test.test(x);
    }

    default public ComposableIntPredicate andNot(IntRelation relation, int object) {
        return x -> this.meFirst(x) && !relation.exists(x, object);
    }

    default public ComposableIntPredicate and(IntRelation relation, Quantifier quantifier, int ... objects) {
        return x -> this.meFirst(x) && Private.testAgainstArray(x, relation, quantifier, objects);
    }

    default public <T> ComposableIntPredicate andThat(T value, Predicate<T> test) {
        return x -> this.meFirst(x) && test.test(value);
    }

    default public ComposableIntPredicate andThat(int value, IntPredicate test) {
        return x -> this.meFirst(x) && test.test(value);
    }

    default public <S, O> ComposableIntPredicate andThat(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) && relation.exists(subject, object);
    }

    default public ComposableIntPredicate andThat(int subject, IntRelation relation, int object) {
        return x -> this.meFirst(x) && relation.exists(subject, object);
    }

    default public <T> ComposableIntPredicate andNot(T value, Predicate<T> test) {
        return x -> this.meFirst(x) && !test.test(value);
    }

    default public ComposableIntPredicate andNot(int value, IntPredicate test) {
        return x -> this.meFirst(x) && !test.test(value);
    }

    default public <S, O> ComposableIntPredicate andNot(S subject, Relation<S, O> relation, O object) {
        return x -> this.meFirst(x) && !relation.exists(subject, object);
    }

    default public ComposableIntPredicate andNot(int subject, IntRelation relation, int object) {
        return x -> this.meFirst(x) && !relation.exists(subject, object);
    }

    default public <S, O, P extends O> ComposableIntPredicate and(S subject, Relation<S, O> relation, Quantifier quantifier, P ... objects) {
        return x -> this.meFirst(x) && Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    default public ComposableIntPredicate and(int subject, IntRelation relation, Quantifier quantifier, int ... objects) {
        return x -> this.meFirst(x) && Private.testAgainstArray(subject, relation, quantifier, objects);
    }

    private boolean meFirst(int i) {
        return this.test(i);
    }
}

