/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.aux;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.aux.Emptyable;
import org.klojang.check.fallible.FallibleConsumer;

public final class Result<T>
implements Emptyable {
    private static final Result<?> NONE = new Result<Object>(null);
    private static final Result<?> NULL = new Result<Object>(null);
    private final T val;

    public static <T> Result<T> of(T value) {
        return value == null ? NULL : new Result<T>(value);
    }

    public static <T> Result<T> notAvailable() {
        return NONE;
    }

    private Result(T value) {
        this.val = value;
    }

    public T get() throws NoSuchElementException {
        if (this != NONE) {
            return this.val;
        }
        throw new NoSuchElementException("no result available");
    }

    public boolean isAvailable() {
        return this != NONE;
    }

    public boolean isAvailableAndNull() {
        return this == NULL;
    }

    public boolean isAvailableAndNotNull() {
        return this != NONE && this != NULL;
    }

    public boolean isUnavailable() {
        return this == NONE;
    }

    public <X extends Throwable> void ifAvailable(FallibleConsumer<T, X> consumer) throws X {
        Check.notNull(consumer);
        if (this.isAvailable()) {
            consumer.accept(this.val);
        }
    }

    public T orElse(T defaultValue) {
        return this.isAvailable() ? this.val : defaultValue;
    }

    public Result<T> or(Result<T> alternative) throws IllegalArgumentException {
        Check.notNull(alternative).isNot(CommonChecks.sameAs(), NONE);
        return this.isAvailable() ? this : alternative;
    }

    @Override
    public boolean isEmpty() {
        return this == NONE || CommonChecks.empty().test(this.val);
    }

    @Override
    public boolean isDeepNotEmpty() {
        return this != NONE && CommonChecks.deepNotEmpty().test(this.val);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != Result.class) {
            return false;
        }
        Result other = (Result)obj;
        return Objects.equals(this.val, other.val);
    }

    public int hashCode() {
        return Objects.hashCode(this.val);
    }

    public String toString() {
        return this.val != null ? String.format("Result[%s]", this.val) : "Result.notAvailable";
    }
}

