/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check.aux;

import java.util.Collection;
import java.util.stream.Collectors;
import org.klojang.check.Check;

public class DuplicateValueException
extends RuntimeException {
    public DuplicateValueException() {
        this(Usage.VALUE);
    }

    public DuplicateValueException(String message) {
        super(message);
    }

    public DuplicateValueException(Usage usage) {
        super(DuplicateValueException.createMessage(usage));
    }

    public DuplicateValueException(Usage usage, Object duplicate) {
        super(DuplicateValueException.createMessage(usage, duplicate));
    }

    public DuplicateValueException(Usage usage, Collection<Object> duplicates) {
        super(DuplicateValueException.createMessage(usage, duplicates));
    }

    private static String createMessage(Usage usage) {
        Check.notNull(usage, "usage");
        return "duplicate " + usage.description();
    }

    private static String createMessage(Usage usage, Object duplicate) {
        Check.notNull(usage, "usage");
        return "duplicate " + usage.description() + ": " + String.valueOf(duplicate);
    }

    private static String createMessage(Usage usage, Collection<Object> duplicates) {
        Check.notNull(usage, "usage");
        Check.notNull(usage, "duplicates");
        String str = duplicates.stream().map(String::valueOf).collect(Collectors.joining(", "));
        return "duplicate " + usage.description() + "s: " + str;
    }

    public static enum Usage {
        KEY,
        ELEMENT,
        VALUE;


        private String description() {
            return this.name().toLowerCase();
        }
    }
}

