/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.klojang.check.CommonProperties;
import org.klojang.check.ObjectCheck;
import org.klojang.check.relation.IntObjRelation;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.x.msg.CheckDefs;
import org.klojang.check.x.msg.MsgArgs;
import org.klojang.check.x.msg.MsgUtil;

final class ObjectCheckHelper2<T, X extends Exception> {
    private final ObjectCheck<T, X> check;

    static <T, X extends Exception> ObjectCheckHelper2<T, X> help(ObjectCheck<T, X> check) {
        return new ObjectCheckHelper2<T, X>(check);
    }

    private ObjectCheckHelper2(ObjectCheck<T, X> check) {
        this.check = check;
    }

    ObjectCheck<T, X> has(ToIntFunction<T> prop, IntPredicate test) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.test(val)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(name, val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, Integer.TYPE, null));
    }

    ObjectCheck<T, X> notHas(ToIntFunction<T> prop, IntPredicate test) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.test(val)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(name, val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, Integer.TYPE, null));
    }

    ObjectCheck<T, X> has(ToIntFunction<T> prop, String name, IntPredicate test) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.test(val)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(check.FQN(name), val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, Integer.TYPE, null));
    }

    ObjectCheck<T, X> notHas(ToIntFunction<T> prop, String name, IntPredicate test) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.test(val)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(check.FQN(name), val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, Integer.TYPE, null));
    }

    ObjectCheck<T, X> has(ToIntFunction<T> prop, IntPredicate test, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.test(val)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, null));
    }

    ObjectCheck<T, X> notHas(ToIntFunction<T> prop, IntPredicate test, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.test(val)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, null));
    }

    <X2 extends Exception> ObjectCheck<T, X> has(ToIntFunction<T> prop, IntPredicate test, Supplier<X2> exception) throws X2 {
        ObjectCheck<T, X> check = this.check;
        if (test.test(prop.applyAsInt(check.arg))) {
            return check;
        }
        throw (Exception)exception.get();
    }

    public <O> ObjectCheck<T, X> has(ToIntFunction<T> prop, IntObjRelation<O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntObjRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, Integer.TYPE, obj));
    }

    public <O> ObjectCheck<T, X> notHas(ToIntFunction<T> prop, IntObjRelation<O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntObjRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, Integer.TYPE, obj));
    }

    <O> ObjectCheck<T, X> has(ToIntFunction<T> prop, String name, IntObjRelation<O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntObjRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, Integer.TYPE, obj));
    }

    <O> ObjectCheck<T, X> notHas(ToIntFunction<T> prop, String name, IntObjRelation<O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntObjRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, Integer.TYPE, obj));
    }

    <O> ObjectCheck<T, X> has(ToIntFunction<T> prop, IntObjRelation<O> test, O obj, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, obj));
    }

    <O> ObjectCheck<T, X> notHas(ToIntFunction<T> prop, IntObjRelation<O> test, O obj, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, obj));
    }

    <O, X2 extends Exception> ObjectCheck<T, X> has(ToIntFunction<T> prop, IntObjRelation<O> test, O obj, Supplier<X2> exception) throws X2 {
        ObjectCheck<T, X> check = this.check;
        if (test.exists(prop.applyAsInt(check.arg), obj)) {
            return check;
        }
        throw (Exception)exception.get();
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> prop, IntRelation test, int obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, Integer.TYPE, obj));
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> prop, IntRelation test, int obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, Integer.TYPE, obj));
    }

    ObjectCheck<T, X> has(ToIntFunction<T> prop, String name, IntRelation test, int obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, Integer.TYPE, obj));
    }

    ObjectCheck<T, X> notHas(ToIntFunction<T> prop, String name, IntRelation test, int obj) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, Integer.TYPE, obj));
    }

    ObjectCheck<T, X> has(ToIntFunction<T> prop, IntRelation test, int obj, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, obj));
    }

    ObjectCheck<T, X> notHas(ToIntFunction<T> prop, IntRelation test, int obj, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, obj));
    }

    <X2 extends Exception> ObjectCheck<T, X> has(ToIntFunction<T> prop, IntRelation test, int obj, Supplier<X2> exception) throws X2 {
        ObjectCheck<T, X> check = this.check;
        if (test.exists(prop.applyAsInt(check.arg), obj)) {
            return check;
        }
        throw (Exception)exception.get();
    }
}

