/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.klojang.check.CommonProperties;
import org.klojang.check.ObjectCheck;
import org.klojang.check.relation.Relation;
import org.klojang.check.x.msg.CheckDefs;
import org.klojang.check.x.msg.MsgArgs;
import org.klojang.check.x.msg.MsgUtil;

final class ObjectCheckHelper1<T, X extends Exception> {
    private final ObjectCheck<T, X> check;

    static <T, X extends Exception> ObjectCheckHelper1<T, X> help(ObjectCheck<T, X> check) {
        return new ObjectCheckHelper1<T, X>(check);
    }

    private ObjectCheckHelper1(ObjectCheck<T, X> check) {
        this.check = check;
    }

    <P> ObjectCheck<T, X> has(Function<T, P> prop, String name, Predicate<P> test) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (test.test(val)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(check.FQN(name), val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, null, null));
    }

    <P> ObjectCheck<T, X> notHas(Function<T, P> prop, String name, Predicate<P> test) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (!test.test(val)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(check.FQN(name), val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, null, null));
    }

    <P> ObjectCheck<T, X> has(Function<T, P> prop, Predicate<P> test) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (test.test(val)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(name, val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, null, null));
    }

    <P> ObjectCheck<T, X> notHas(Function<T, P> prop, Predicate<P> test) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (!test.test(val)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(name, val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, null, null));
    }

    <P> ObjectCheck<T, X> has(Function<T, P> prop, Predicate<P> test, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (test.test(val)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, null, null));
    }

    <P> ObjectCheck<T, X> notHas(Function<T, P> prop, Predicate<P> test, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (!test.test(val)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, null, null));
    }

    <P, X2 extends Exception> ObjectCheck<T, X> has(Function<T, P> prop, Predicate<P> test, Supplier<X2> exc) throws X2 {
        ObjectCheck<T, X> check = this.check;
        if (test.test(prop.apply(check.arg))) {
            return check;
        }
        throw (Exception)exc.get();
    }

    public <P, O> ObjectCheck<T, X> has(Function<T, P> prop, Relation<P, O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, null, obj));
    }

    public <P, O> ObjectCheck<T, X> notHas(Function<T, P> prop, Relation<P, O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, prop, Function.class);
        Function<MsgArgs, String> formatter = CheckDefs.getRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, null, obj));
    }

    <P, O> ObjectCheck<T, X> has(Function<T, P> prop, String name, Relation<P, O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, null, obj));
    }

    <P, O> ObjectCheck<T, X> notHas(Function<T, P> prop, String name, Relation<P, O> test, O obj) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, null, obj));
    }

    <P, O> ObjectCheck<T, X> has(Function<T, P> prop, Relation<P, O> test, O obj, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, null, obj));
    }

    <P, O> ObjectCheck<T, X> notHas(Function<T, P> prop, Relation<P, O> test, O obj, String msg, Object[] msgArgs) throws X {
        ObjectCheck<T, X> check = this.check;
        P val = prop.apply(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, null, obj));
    }

    <P, O, X2 extends Exception> ObjectCheck<T, X> has(Function<T, P> prop, Relation<P, O> test, O obj, Supplier<X2> exc) throws X2 {
        ObjectCheck<T, X> check = this.check;
        if (test.exists(prop.apply(check.arg), obj)) {
            return check;
        }
        throw (Exception)exc.get();
    }
}

