/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.klojang.check.IntCheck;
import org.klojang.check.ObjectCheckHelper1;
import org.klojang.check.ObjectCheckHelper2;
import org.klojang.check.fallible.FallibleConsumer;
import org.klojang.check.fallible.FallibleFunction;
import org.klojang.check.relation.IntObjRelation;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Relation;
import org.klojang.check.x.msg.CheckDefs;
import org.klojang.check.x.msg.MsgArgs;
import org.klojang.check.x.msg.MsgUtil;

public final class ObjectCheck<T, X extends Exception> {
    final T arg;
    final String argName;
    final Function<String, X> exc;

    ObjectCheck(T arg, String argName, Function<String, X> exc) {
        this.arg = arg;
        this.argName = argName;
        this.exc = exc;
    }

    public T ok() {
        return this.arg;
    }

    public <R, X2 extends Throwable> R ok(FallibleFunction<T, R, X2> transformer) throws X2 {
        return transformer.apply(this.arg);
    }

    public <X2 extends Throwable> void then(FallibleConsumer<T, X2> consumer) throws X2 {
        consumer.accept(this.arg);
    }

    public ObjectCheck<T, X> is(Predicate<T> test) throws X {
        if (test.test(this.arg)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultPredicateMessage(this.argName, this.arg));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, this.argName, this.arg, null, null));
    }

    public ObjectCheck<T, X> isNot(Predicate<T> test) throws X {
        if (!test.test(this.arg)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultPredicateMessage(this.argName, this.arg));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, this.argName, this.arg, null, null));
    }

    public ObjectCheck<T, X> is(Predicate<T> test, String message, Object ... msgArgs) throws X {
        if (test.test(this.arg)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, null, null));
    }

    public ObjectCheck<T, X> isNot(Predicate<T> test, String message, Object ... msgArgs) throws X {
        if (!test.test(this.arg)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, null, null));
    }

    public <X2 extends Exception> ObjectCheck<T, X> is(Predicate<T> test, Supplier<X2> exception) throws X2 {
        if (test.test(this.arg)) {
            return this;
        }
        throw (Exception)exception.get();
    }

    public <X2 extends Exception> ObjectCheck<T, X> isNot(Predicate<T> test, Supplier<X2> exception) throws X2 {
        return this.is(test.negate(), exception);
    }

    public <O> ObjectCheck<T, X> is(Relation<T, O> test, O object) throws X {
        if (test.exists(this.arg, object)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultRelationMessage(this.argName, this.arg, object));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, this.argName, this.arg, null, object));
    }

    public <O> ObjectCheck<T, X> isNot(Relation<T, O> test, O object) throws X {
        if (!test.exists(this.arg, object)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultRelationMessage(this.argName, this.arg, object));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, this.argName, this.arg, null, object));
    }

    public <O> ObjectCheck<T, X> is(Relation<T, O> test, O object, String message, Object ... msgArgs) throws X {
        if (test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, null, object));
    }

    public <O> ObjectCheck<T, X> isNot(Relation<T, O> test, O object, String message, Object ... msgArgs) throws X {
        if (!test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, null, object));
    }

    public <O, X2 extends Exception> ObjectCheck<T, X> is(Relation<T, O> test, O object, Supplier<X2> exception) throws X2 {
        if (test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)exception.get();
    }

    public <O, X2 extends Exception> ObjectCheck<T, X> isNot(Relation<T, O> test, O object, Supplier<X2> exception) throws X2 {
        return this.is(test.negate(), object, exception);
    }

    public <P> ObjectCheck<T, X> has(Function<T, P> property, Predicate<P> test) throws X {
        return ObjectCheckHelper1.help(this).has(property, test);
    }

    public <P> ObjectCheck<T, X> notHas(Function<T, P> property, Predicate<P> test) throws X {
        return ObjectCheckHelper1.help(this).notHas(property, test);
    }

    public <P> ObjectCheck<T, X> has(Function<T, P> property, String name, Predicate<P> test) throws X {
        return ObjectCheckHelper1.help(this).has(property, name, test);
    }

    public <P> ObjectCheck<T, X> notHas(Function<T, P> property, String name, Predicate<P> test) throws X {
        return ObjectCheckHelper1.help(this).notHas(property, name, test);
    }

    public <P> ObjectCheck<T, X> has(Function<T, P> property, Predicate<P> test, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper1.help(this).has(property, test, message, msgArgs);
    }

    public <P> ObjectCheck<T, X> notHas(Function<T, P> property, Predicate<P> test, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper1.help(this).notHas(property, test, message, msgArgs);
    }

    public <P, X2 extends Exception> ObjectCheck<T, X> has(Function<T, P> property, Predicate<P> test, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper1.help(this).has(property, test, exception);
    }

    public <P, X2 extends Exception> ObjectCheck<T, X> notHas(Function<T, P> property, Predicate<P> test, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper1.help(this).has(property, test.negate(), exception);
    }

    public <P, O> ObjectCheck<T, X> has(Function<T, P> property, Relation<P, O> test, O object) throws X {
        return ObjectCheckHelper1.help(this).has(property, test, object);
    }

    public <P, O> ObjectCheck<T, X> notHas(Function<T, P> property, Relation<P, O> test, O object) throws X {
        return ObjectCheckHelper1.help(this).notHas(property, test, object);
    }

    public <P, O> ObjectCheck<T, X> has(Function<T, P> property, String name, Relation<P, O> test, O object) throws X {
        return ObjectCheckHelper1.help(this).has(property, name, test, object);
    }

    public <P, O> ObjectCheck<T, X> notHas(Function<T, P> property, String name, Relation<P, O> test, O object) throws X {
        return ObjectCheckHelper1.help(this).notHas(property, name, test, object);
    }

    public <P, O> ObjectCheck<T, X> has(Function<T, P> property, Relation<P, O> test, O object, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper1.help(this).has(property, test, object, message, msgArgs);
    }

    public <P, O> ObjectCheck<T, X> notHas(Function<T, P> property, Relation<P, O> test, O object, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper1.help(this).notHas(property, test, object, message, msgArgs);
    }

    public <P, O, X2 extends Exception> ObjectCheck<T, X> has(Function<T, P> property, Relation<P, O> test, O object, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper1.help(this).has(property, test, object, exception);
    }

    public <P, O, X2 extends Exception> ObjectCheck<T, X> notHas(Function<T, P> property, Relation<P, O> test, O object, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper1.help(this).has(property, test.negate(), object, exception);
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> property, IntPredicate test) throws X {
        return ObjectCheckHelper2.help(this).has(property, test);
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntPredicate test) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, test);
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> property, String name, IntPredicate test) throws X {
        return ObjectCheckHelper2.help(this).has(property, name, test);
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> property, String name, IntPredicate test) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, name, test);
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> property, IntPredicate test, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper2.help(this).has(property, test, message, msgArgs);
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntPredicate test, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, test, message, msgArgs);
    }

    public <X2 extends Exception> ObjectCheck<T, X> has(ToIntFunction<T> property, IntPredicate test, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper2.help(this).has(property, test, exception);
    }

    public <X2 extends Exception> ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntPredicate test, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper2.help(this).has(property, test.negate(), exception);
    }

    public <O> ObjectCheck<T, X> has(ToIntFunction<T> property, IntObjRelation<O> test, O object) throws X {
        return ObjectCheckHelper2.help(this).has(property, test, object);
    }

    public <O> ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntObjRelation<O> test, O object) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, test, object);
    }

    public <O> ObjectCheck<T, X> has(ToIntFunction<T> property, String name, IntObjRelation<O> test, O object) throws X {
        return ObjectCheckHelper2.help(this).has(property, name, test, object);
    }

    public <O> ObjectCheck<T, X> notHas(ToIntFunction<T> property, String name, IntObjRelation<O> test, O object) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, name, test, object);
    }

    public <O> ObjectCheck<T, X> has(ToIntFunction<T> property, IntObjRelation<O> test, O object, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper2.help(this).has(property, test, object, message, msgArgs);
    }

    public <O> ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntObjRelation<O> test, O object, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, test, object, message, msgArgs);
    }

    public <O, X2 extends Exception> ObjectCheck<T, X> has(ToIntFunction<T> property, IntObjRelation<O> test, O object, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper2.help(this).has(property, test, object, exception);
    }

    public <O, X2 extends Exception> ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntObjRelation<O> test, O object, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper2.help(this).has(property, test.negate(), object, exception);
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> property, IntRelation test, int object) throws X {
        return ObjectCheckHelper2.help(this).has(property, test, object);
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntRelation test, int object) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, test, object);
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> property, String name, IntRelation test, int object) throws X {
        return ObjectCheckHelper2.help(this).has(property, name, test, object);
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> property, String name, IntRelation test, int object) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, name, test, object);
    }

    public ObjectCheck<T, X> has(ToIntFunction<T> property, IntRelation test, int object, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper2.help(this).has(property, test, object, message, msgArgs);
    }

    public ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntRelation test, int object, String message, Object ... msgArgs) throws X {
        return ObjectCheckHelper2.help(this).notHas(property, test, object, message, msgArgs);
    }

    public <X2 extends Exception> ObjectCheck<T, X> has(ToIntFunction<T> property, IntRelation test, int object, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper2.help(this).has(property, test, object, exception);
    }

    public <X2 extends Exception> ObjectCheck<T, X> notHas(ToIntFunction<T> property, IntRelation test, int object, Supplier<X2> exception) throws X2 {
        return ObjectCheckHelper2.help(this).has(property, test.negate(), object, exception);
    }

    public IntCheck<X> and(int arg) {
        return new IntCheck<X>(arg, "argument", this.exc);
    }

    public IntCheck<X> and(int arg, String argName) {
        return new IntCheck<X>(arg, argName, this.exc);
    }

    public <U> ObjectCheck<U, X> and(U arg) {
        return new ObjectCheck<U, X>(arg, "argument", this.exc);
    }

    public <U> ObjectCheck<U, X> and(U arg, String argName) {
        return new ObjectCheck<U, X>(arg, argName, this.exc);
    }

    String FQN(String propName) {
        if (this.argName == null) {
            return propName;
        }
        return this.argName + "." + propName;
    }
}

