/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import org.klojang.check.CommonProperties;
import org.klojang.check.IntCheck;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.x.msg.CheckDefs;
import org.klojang.check.x.msg.MsgArgs;
import org.klojang.check.x.msg.MsgUtil;

final class IntCheckHelper2<X extends Exception> {
    private final IntCheck<X> check;

    static <X extends Exception> IntCheckHelper2<X> help(IntCheck<X> check) {
        return new IntCheckHelper2<X>(check);
    }

    private IntCheckHelper2(IntCheck<X> check) {
        this.check = check;
    }

    IntCheck<X> has(IntUnaryOperator prop, IntPredicate test) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.test(val)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, (Object)prop, IntUnaryOperator.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(name, val));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, Integer.TYPE, null));
    }

    IntCheck<X> notHas(IntUnaryOperator prop, IntPredicate test) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.test(val)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, (Object)prop, IntUnaryOperator.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(name, check.arg));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, Integer.TYPE, null));
    }

    IntCheck<X> has(IntUnaryOperator prop, String name, IntPredicate test) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.test(val)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(check.FQN(name), check.arg));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, Integer.TYPE, null));
    }

    IntCheck<X> notHas(IntUnaryOperator prop, String name, IntPredicate test) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.test(val)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultPredicateMessage(check.FQN(name), check.arg));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, Integer.TYPE, null));
    }

    IntCheck<X> has(IntUnaryOperator prop, IntPredicate test, String msg, Object[] msgArgs) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.test(val)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, null));
    }

    IntCheck<X> notHas(IntUnaryOperator prop, IntPredicate test, String msg, Object[] msgArgs) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.test(val)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, null));
    }

    <X2 extends Exception> IntCheck<X> has(IntUnaryOperator prop, IntPredicate test, Supplier<X2> exc) throws X2 {
        IntCheck<X> check = this.check;
        if (test.test(prop.applyAsInt(check.arg))) {
            return check;
        }
        throw (Exception)exc.get();
    }

    IntCheck<X> has(IntUnaryOperator prop, IntRelation test, int obj) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, (Object)prop, IntUnaryOperator.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, name, val, Integer.TYPE, obj));
    }

    IntCheck<X> notHas(IntUnaryOperator prop, IntRelation test, int obj) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        String name = CommonProperties.formatProperty(check.arg, check.argName, (Object)prop, IntUnaryOperator.class);
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(name, val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, name, val, Integer.TYPE, obj));
    }

    IntCheck<X> has(IntUnaryOperator prop, String name, IntRelation test, int obj) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), check.arg, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, check.FQN(name), val, Integer.TYPE, obj));
    }

    IntCheck<X> notHas(IntUnaryOperator prop, String name, IntRelation test, int obj) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)check.exc.apply(MsgUtil.getDefaultRelationMessage(check.FQN(name), val, obj));
        }
        throw (Exception)check.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, check.FQN(name), val, Integer.TYPE, obj));
    }

    IntCheck<X> has(IntUnaryOperator prop, IntRelation test, int obj, String msg, Object[] msgArgs) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, obj));
    }

    IntCheck<X> notHas(IntUnaryOperator prop, IntRelation test, int obj, String msg, Object[] msgArgs) throws X {
        IntCheck<X> check = this.check;
        int val = prop.applyAsInt(check.arg);
        if (!test.exists(val, obj)) {
            return check;
        }
        throw (Exception)check.exc.apply(MsgUtil.getCustomMessage(msg, msgArgs, test, check.argName, val, Integer.TYPE, obj));
    }

    <X2 extends Exception> IntCheck<X> has(IntUnaryOperator prop, IntRelation test, int obj, Supplier<X2> exc) throws X2 {
        IntCheck<X> check = this.check;
        if (test.exists(prop.applyAsInt(check.arg), obj)) {
            return check;
        }
        throw (Exception)exc.get();
    }
}

