/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.klojang.check.IntCheckHelper1;
import org.klojang.check.IntCheckHelper2;
import org.klojang.check.ObjectCheck;
import org.klojang.check.fallible.FallibleIntConsumer;
import org.klojang.check.fallible.FallibleIntFunction;
import org.klojang.check.fallible.FallibleIntUnaryOperator;
import org.klojang.check.relation.IntObjRelation;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Relation;
import org.klojang.check.x.msg.CheckDefs;
import org.klojang.check.x.msg.MsgArgs;
import org.klojang.check.x.msg.MsgUtil;

public final class IntCheck<X extends Exception> {
    final int arg;
    final String argName;
    final Function<String, X> exc;

    IntCheck(int arg, String argName, Function<String, X> exc) {
        this.arg = arg;
        this.argName = argName;
        this.exc = exc;
    }

    public int ok() {
        return this.arg;
    }

    public <X2 extends Throwable> int ok(FallibleIntUnaryOperator<X2> transformer) throws X2 {
        return transformer.applyAsInt(this.arg);
    }

    public <R, X2 extends Throwable> R mapToObj(FallibleIntFunction<R, X2> transformer) throws X2 {
        return transformer.apply(this.arg);
    }

    public <X2 extends Throwable> void then(FallibleIntConsumer<X2> consumer) throws X2 {
        consumer.accept(this.arg);
    }

    public IntCheck<X> is(IntPredicate test) throws X {
        if (test.test(this.arg)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultPredicateMessage(this.argName, this.arg));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, this.argName, this.arg, Integer.TYPE, null));
    }

    public IntCheck<X> isNot(IntPredicate test) throws X {
        if (!test.test(this.arg)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntPredicateFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultPredicateMessage(this.argName, this.arg));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, this.argName, this.arg, Integer.TYPE, null));
    }

    public IntCheck<X> is(IntPredicate test, String message, Object ... msgArgs) throws X {
        if (test.test(this.arg)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, Integer.TYPE, null));
    }

    public IntCheck<X> isNot(IntPredicate test, String message, Object ... msgArgs) throws X {
        if (!test.test(this.arg)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, Integer.TYPE, null));
    }

    public <X2 extends Exception> IntCheck<X> is(IntPredicate test, Supplier<X2> exception) throws X2 {
        if (test.test(this.arg)) {
            return this;
        }
        throw (Exception)exception.get();
    }

    public <X2 extends Exception> IntCheck<X> isNot(IntPredicate test, Supplier<X2> exception) throws X2 {
        return this.is(test.negate(), exception);
    }

    public IntCheck<X> is(IntRelation test, int object) throws X {
        if (test.exists(this.arg, object)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultRelationMessage(this.argName, this.arg, object));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, this.argName, this.arg, Integer.TYPE, object));
    }

    public IntCheck<X> isNot(IntRelation test, int object) throws X {
        if (!test.exists(this.arg, object)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultRelationMessage(this.argName, this.arg, object));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, this.argName, this.arg, Integer.TYPE, object));
    }

    public IntCheck<X> is(IntRelation test, int object, String message, Object ... msgArgs) throws X {
        if (test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, Integer.TYPE, object));
    }

    public IntCheck<X> isNot(IntRelation test, int object, String message, Object ... msgArgs) throws X {
        if (!test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, Integer.TYPE, object));
    }

    public <X2 extends Exception> IntCheck<X> is(IntRelation test, int object, Supplier<X2> exception) throws X2 {
        if (test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)exception.get();
    }

    public <X2 extends Exception> IntCheck<X> isNot(IntRelation test, int object, Supplier<X2> exception) throws X2 {
        return this.is(test.negate(), object, exception);
    }

    public <O> IntCheck<X> is(IntObjRelation<O> test, O object) throws X {
        if (test.exists(this.arg, object)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntObjRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultRelationMessage(this.argName, this.arg, object));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, false, this.argName, this.arg, Integer.TYPE, object));
    }

    public <O> IntCheck<X> isNot(IntObjRelation<O> test, O object) throws X {
        if (!test.exists(this.arg, object)) {
            return this;
        }
        Function<MsgArgs, String> formatter = CheckDefs.getIntObjRelationFormatter(test);
        if (formatter == null) {
            throw (Exception)this.exc.apply(MsgUtil.getDefaultRelationMessage(this.argName, this.arg, object));
        }
        throw (Exception)this.exc.apply(MsgUtil.getPrefabMessage(formatter, test, true, this.argName, this.arg, Integer.TYPE, object));
    }

    public <O> IntCheck<X> is(IntObjRelation<O> test, O object, String message, Object ... msgArgs) throws X {
        if (test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, Integer.TYPE, object));
    }

    public <O> IntCheck<X> isNot(IntObjRelation<O> test, O object, String message, Object ... msgArgs) throws X {
        if (!test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)this.exc.apply(MsgUtil.getCustomMessage(message, msgArgs, test, this.argName, this.arg, Integer.TYPE, object));
    }

    public <O, X2 extends Exception> IntCheck<X> is(IntObjRelation<O> test, O object, Supplier<X2> exception) throws X2 {
        if (test.exists(this.arg, object)) {
            return this;
        }
        throw (Exception)exception.get();
    }

    public <O, X2 extends Exception> IntCheck<X> isNot(IntObjRelation<O> test, O object, Supplier<X2> exception) throws X2 {
        return this.is(test.negate(), object, exception);
    }

    public <P> IntCheck<X> has(IntFunction<P> property, Predicate<P> test) throws X {
        return IntCheckHelper1.help(this).has(property, test);
    }

    public <P> IntCheck<X> notHas(IntFunction<P> property, Predicate<P> test) throws X {
        return IntCheckHelper1.help(this).notHas(property, test);
    }

    public <P> IntCheck<X> has(IntFunction<P> property, String name, Predicate<P> test) throws X {
        return IntCheckHelper1.help(this).has(property, name, test);
    }

    public <P> IntCheck<X> notHas(IntFunction<P> property, String name, Predicate<P> test) throws X {
        return IntCheckHelper1.help(this).notHas(property, name, test);
    }

    public <P> IntCheck<X> has(IntFunction<P> property, Predicate<P> test, String message, Object ... msgArgs) throws X {
        return IntCheckHelper1.help(this).has(property, test, message, msgArgs);
    }

    public <P> IntCheck<X> notHas(IntFunction<P> property, Predicate<P> test, String message, Object ... msgArgs) throws X {
        return IntCheckHelper1.help(this).notHas(property, test, message, msgArgs);
    }

    public <P, X2 extends Exception> IntCheck<X> has(IntFunction<P> property, Predicate<P> test, Supplier<X2> exception) throws X2 {
        return IntCheckHelper1.help(this).has(property, test, exception);
    }

    public <P, X2 extends Exception> IntCheck<X> notHas(IntFunction<P> property, Predicate<P> test, Supplier<X2> exception) throws X2 {
        return IntCheckHelper1.help(this).has(property, test.negate(), exception);
    }

    public <P, O> IntCheck<X> has(IntFunction<P> property, Relation<P, O> test, O object) throws X {
        return IntCheckHelper1.help(this).has(property, test, object);
    }

    public <P, O> IntCheck<X> notHas(IntFunction<P> property, Relation<P, O> test, O object) throws X {
        return IntCheckHelper1.help(this).notHas(property, test, object);
    }

    public <P, O> IntCheck<X> has(IntFunction<P> property, String name, Relation<P, O> test, O object) throws X {
        return IntCheckHelper1.help(this).has(property, name, test, object);
    }

    public <P, O> IntCheck<X> notHas(IntFunction<P> property, String name, Relation<P, O> test, O object) throws X {
        return IntCheckHelper1.help(this).notHas(property, name, test, object);
    }

    public <P, O> IntCheck<X> has(IntFunction<P> property, Relation<P, O> test, O object, String message, Object ... msgArgs) throws X {
        return IntCheckHelper1.help(this).has(property, test, object, message, msgArgs);
    }

    public <P, O> IntCheck<X> notHas(IntFunction<P> property, Relation<P, O> test, O object, String message, Object ... msgArgs) throws X {
        return IntCheckHelper1.help(this).notHas(property, test, object, message, msgArgs);
    }

    public <P, O, X2 extends Exception> IntCheck<X> has(IntFunction<P> property, Relation<P, O> test, O object, Supplier<X2> exception) throws X2 {
        return IntCheckHelper1.help(this).has(property, test, object, exception);
    }

    public <P, O, X2 extends Exception> IntCheck<X> notHas(IntFunction<P> property, Relation<P, O> test, O object, Supplier<X2> exception) throws X2 {
        return IntCheckHelper1.help(this).has(property, test.negate(), object, exception);
    }

    public IntCheck<X> has(IntUnaryOperator property, IntPredicate test) throws X {
        return IntCheckHelper2.help(this).has(property, test);
    }

    public IntCheck<X> notHas(IntUnaryOperator property, IntPredicate test) throws X {
        return IntCheckHelper2.help(this).notHas(property, test);
    }

    public IntCheck<X> has(IntUnaryOperator property, String name, IntPredicate test) throws X {
        return IntCheckHelper2.help(this).has(property, name, test);
    }

    public IntCheck<X> notHas(IntUnaryOperator property, String name, IntPredicate test) throws X {
        return IntCheckHelper2.help(this).notHas(property, name, test);
    }

    public IntCheck<X> has(IntUnaryOperator property, IntPredicate test, String message, Object ... msgArgs) throws X {
        return IntCheckHelper2.help(this).has(property, test, message, msgArgs);
    }

    public IntCheck<X> notHas(IntUnaryOperator property, IntPredicate test, String message, Object ... msgArgs) throws X {
        return IntCheckHelper2.help(this).notHas(property, test, message, msgArgs);
    }

    public <X2 extends Exception> IntCheck<X> has(IntUnaryOperator property, IntPredicate test, Supplier<X2> exception) throws X2 {
        return IntCheckHelper2.help(this).has(property, test, exception);
    }

    public <X2 extends Exception> IntCheck<X> notHas(IntUnaryOperator property, IntPredicate test, Supplier<X2> exception) throws X2 {
        return IntCheckHelper2.help(this).has(property, test.negate(), exception);
    }

    public IntCheck<X> has(IntUnaryOperator property, IntRelation test, int object) throws X {
        return IntCheckHelper2.help(this).has(property, test, object);
    }

    public IntCheck<X> notHas(IntUnaryOperator property, IntRelation test, int object) throws X {
        return IntCheckHelper2.help(this).notHas(property, test, object);
    }

    public IntCheck<X> has(IntUnaryOperator property, String name, IntRelation test, int object) throws X {
        return IntCheckHelper2.help(this).has(property, name, test, object);
    }

    public IntCheck<X> notHas(IntUnaryOperator property, String name, IntRelation test, int object) throws X {
        return IntCheckHelper2.help(this).notHas(property, name, test, object);
    }

    public IntCheck<X> has(IntUnaryOperator property, IntRelation test, int object, String message, Object ... msgArgs) throws X {
        return IntCheckHelper2.help(this).has(property, test, object, message, msgArgs);
    }

    public IntCheck<X> notHas(IntUnaryOperator property, IntRelation test, int object, String message, Object ... msgArgs) throws X {
        return IntCheckHelper2.help(this).notHas(property, test, object, message, msgArgs);
    }

    public <X2 extends Exception> IntCheck<X> has(IntUnaryOperator property, IntRelation test, int object, Supplier<X2> exception) throws X2 {
        return IntCheckHelper2.help(this).has(property, test, object, exception);
    }

    public <X2 extends Exception> IntCheck<X> notHas(IntUnaryOperator property, IntRelation test, int object, Supplier<X2> exception) throws X2 {
        return this.has(property, test.negate(), object, exception);
    }

    public IntCheck<X> and(int arg) {
        return new IntCheck<X>(arg, "argument", this.exc);
    }

    public IntCheck<X> and(int arg, String argName) {
        return new IntCheck<X>(arg, argName, this.exc);
    }

    public <T> ObjectCheck<T, X> and(T arg) {
        return new ObjectCheck<T, X>(arg, "argument", this.exc);
    }

    public <T> ObjectCheck<T, X> and(T arg, String argName) {
        return new ObjectCheck<T, X>(arg, argName, this.exc);
    }

    String FQN(String name) {
        if (this.argName == null) {
            return name;
        }
        return this.argName + "." + name;
    }
}

