/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import org.klojang.check.x.Misc;
import org.klojang.check.x.msg.MsgUtil;

public class CommonProperties {
    private static final Map<Object, BiFunction<Object, String, String>> NAMES;
    private static Map<Object, BiFunction<Object, String, String>> tmp;
    private static final Map<Class<?>, UnaryOperator<? extends Number>> absFunctions;

    private CommonProperties() {
    }

    public static IntFunction<Integer> box() {
        return Integer::valueOf;
    }

    public static ToIntFunction<Integer> unbox() {
        return Integer::intValue;
    }

    public static <T> Function<T, String> strval() {
        return Object::toString;
    }

    public static <T extends CharSequence> ToIntFunction<T> strlen() {
        return CharSequence::length;
    }

    public static Function<String, String> toUpperCase() {
        return String::toUpperCase;
    }

    public static Function<String, String> toLowerCase() {
        return String::toLowerCase;
    }

    public static <T> Function<T, Class<?>> type() {
        return Object::getClass;
    }

    public static <T extends Enum<T>> Function<Class<T>, T[]> constants() {
        return x -> (Enum[])x.getEnumConstants();
    }

    public static <T extends Enum<?>> Function<T, String> name() {
        return Enum::name;
    }

    public static <T extends Enum<?>> ToIntFunction<T> ordinal() {
        return Enum::ordinal;
    }

    public static <T> ToIntFunction<T> length() {
        return Array::getLength;
    }

    public static <C extends Collection<?>> ToIntFunction<C> size() {
        return Collection::size;
    }

    public static <L extends List<?>> ToIntFunction<L> listSize() {
        return List::size;
    }

    public static <S extends Set<?>> ToIntFunction<S> setSize() {
        return Set::size;
    }

    public static <M extends Map<?, ?>> ToIntFunction<M> mapSize() {
        return Map::size;
    }

    public static <K, V, M extends Map<K, V>> Function<M, Set<K>> keySet() {
        return Map::keySet;
    }

    public static <K, V, M extends Map<K, V>> Function<M, Collection<V>> values() {
        return Map::values;
    }

    public static <K, V> Function<Map.Entry<K, V>, K> key() {
        return Map.Entry::getKey;
    }

    public static <K, V> Function<Map.Entry<K, V>, V> value() {
        return Map.Entry::getValue;
    }

    public static IntUnaryOperator abs() {
        return Math::abs;
    }

    public static <T extends Number> Function<T, T> ABS() {
        return n -> {
            UnaryOperator<? extends Number> op = absFunctions.get(n.getClass());
            if (op != null) {
                return (Number)op.apply((Number)n);
            }
            throw Misc.typeNotSupported(n.getClass());
        };
    }

    static String formatProperty(Object arg, String argName, Object getter, Class getterClass) {
        BiFunction<Object, String, String> fmt = NAMES.get(getter);
        if (fmt == null) {
            String s0 = getterClass == ToIntFunction.class ? "applyAsInt" : "apply";
            return MsgUtil.simpleClassName(getterClass) + "." + s0 + "(" + MsgUtil.toStr(arg) + ")";
        }
        return fmt.apply(arg, argName);
    }

    static String formatProperty(int arg, String argName, Object getter, Class getterClass) {
        BiFunction<Object, String, String> fmt = NAMES.get(getter);
        if (fmt == null) {
            String s0 = getterClass == IntUnaryOperator.class ? "applyAsInt" : "apply";
            return MsgUtil.simpleClassName(getterClass) + "." + s0 + "(" + arg + ")";
        }
        return fmt.apply(arg, argName);
    }

    private static String base(String argName, Object arg) {
        return CommonProperties.ifNull(argName, MsgUtil.simpleClassName(arg));
    }

    private static String ifNull(String value, String defVal) {
        return value == null ? defVal : value;
    }

    static {
        tmp = new HashMap<Object, BiFunction<Object, String, String>>();
        tmp.put(CommonProperties.box(), (arg, argName) -> "Integer.valueOf(" + CommonProperties.ifNull(argName, "argument") + ")");
        tmp.put(CommonProperties.unbox(), (arg, argName) -> "Integer.intValue(" + CommonProperties.ifNull(argName, "argument") + ")");
        tmp.put(CommonProperties.strval(), (arg, argName) -> CommonProperties.base(argName, arg) + ".toString()");
        tmp.put(CommonProperties.strlen(), (arg, argName) -> CommonProperties.base(argName, arg) + ".length()");
        tmp.put(CommonProperties.toUpperCase(), (arg, argName) -> CommonProperties.base(argName, arg) + ".toUpperCase()");
        tmp.put(CommonProperties.toLowerCase(), (arg, argName) -> CommonProperties.base(argName, arg) + ".toLowerCase()");
        tmp.put(CommonProperties.type(), (arg, argName) -> CommonProperties.base(argName, arg) + ".getClass()");
        tmp.put(CommonProperties.constants(), (arg, argName) -> CommonProperties.base(argName, arg) + ".getEnumConstants()");
        tmp.put(CommonProperties.name(), (arg, argName) -> CommonProperties.base(argName, arg) + ".name()");
        tmp.put(CommonProperties.ordinal(), (arg, argName) -> CommonProperties.base(argName, arg) + ".ordinal()");
        tmp.put(CommonProperties.length(), (arg, argName) -> CommonProperties.base(argName, arg) + ".length");
        tmp.put(CommonProperties.size(), (arg, argName) -> CommonProperties.base(argName, arg) + ".size()");
        tmp.put(CommonProperties.listSize(), tmp.get(CommonProperties.size()));
        tmp.put(CommonProperties.setSize(), tmp.get(CommonProperties.size()));
        tmp.put(CommonProperties.mapSize(), tmp.get(CommonProperties.size()));
        tmp.put(CommonProperties.keySet(), (arg, argName) -> CommonProperties.base(argName, arg) + ".keySet()");
        tmp.put(CommonProperties.values(), (arg, argName) -> CommonProperties.base(argName, arg) + ".values()");
        tmp.put(CommonProperties.key(), (arg, argName) -> CommonProperties.base(argName, arg) + ".getKey()");
        tmp.put(CommonProperties.value(), (arg, argName) -> CommonProperties.base(argName, arg) + ".getValue()");
        tmp.put(CommonProperties.abs(), (arg, argName) -> "abs(" + CommonProperties.ifNull(argName, "argument") + ")");
        absFunctions = Map.of(Integer.class, n -> n.intValue() >= 0 ? (Number)((Number)n) : (Number)(-n.intValue()), Double.class, n -> n.doubleValue() >= 0.0 ? (Number)((Number)n) : (Number)(-n.doubleValue()), Long.class, n -> n.longValue() >= 0L ? (Number)((Number)n) : (Number)(-n.longValue()), Float.class, n -> n.floatValue() >= 0.0f ? (Number)((Number)n) : (Number)Float.valueOf(-n.floatValue()), Short.class, n -> n.shortValue() >= 0 ? (Number)((Number)n) : (Number)(-n.shortValue()), Byte.class, n -> n.byteValue() >= 0 ? (Number)((Number)n) : (Number)(-n.byteValue()), BigInteger.class, n -> ((BigInteger)n).abs(), BigDecimal.class, n -> ((BigDecimal)n).abs());
        tmp.put(CommonProperties.ABS(), (arg, argName) -> "abs(" + CommonProperties.base(argName, arg) + ")");
        NAMES = Map.copyOf(tmp);
        tmp = null;
    }
}

