/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.klojang.check.aux.DuplicateValueException;

public final class CommonExceptions {
    public static final Function<String, IllegalStateException> STATE = IllegalStateException::new;
    public static final Function<String, IndexOutOfBoundsException> INDEX = IndexOutOfBoundsException::new;
    public static final Function<String, IOException> IO = IOException::new;
    public static final Function<String, FileNotFoundException> FILE = FileNotFoundException::new;
    public static final Function<String, NullPointerException> NPE = NullPointerException::new;
    public static final Function<String, NoSuchElementException> ELEMENT = NoSuchElementException::new;
    public static final Function<String, DuplicateValueException> DUPLICATE = DuplicateValueException::new;
    public static final Function<String, IllegalArgumentException> ARGUMENT = IllegalArgumentException::new;

    private CommonExceptions() {
        throw new UnsupportedOperationException();
    }

    public static Supplier<IllegalStateException> illegalState(String message) {
        return () -> new IllegalStateException(message);
    }

    public static Supplier<IllegalStateException> illegalState() {
        return IllegalStateException::new;
    }

    public static Supplier<IllegalArgumentException> illegalArgument(String message) {
        return () -> new IllegalArgumentException(message);
    }

    public static Supplier<IllegalArgumentException> illegalArgument() {
        return IllegalArgumentException::new;
    }

    public static Supplier<IndexOutOfBoundsException> indexOutOfBounds(int index) {
        return () -> new IndexOutOfBoundsException(index);
    }

    public static Supplier<IndexOutOfBoundsException> indexOutOfBounds(String message) {
        return () -> new IndexOutOfBoundsException(message);
    }

    public static Supplier<IOException> ioException(String message) {
        return () -> new IOException(message);
    }

    public static Supplier<IOException> ioException() {
        return IOException::new;
    }

    public static Supplier<FileNotFoundException> fileNotFound(String message) {
        return () -> new FileNotFoundException(message);
    }

    public static Supplier<FileNotFoundException> fileNotFound(File f) {
        return () -> new FileNotFoundException("file not found: " + String.valueOf(f));
    }

    public static Supplier<NullPointerException> npe(String message) {
        return () -> new NullPointerException(message);
    }

    public static Supplier<NullPointerException> npe() {
        return NullPointerException::new;
    }

    public static Supplier<NoSuchElementException> noSuchElement(String message) {
        return () -> new NoSuchElementException(message);
    }

    public static Supplier<NoSuchElementException> noSuchElement() {
        return NoSuchElementException::new;
    }

    public static Supplier<DuplicateValueException> duplicateKey() {
        return () -> new DuplicateValueException(DuplicateValueException.Usage.KEY);
    }

    public static Supplier<DuplicateValueException> duplicateKey(Object key) {
        return () -> new DuplicateValueException(DuplicateValueException.Usage.KEY, key);
    }

    public static Supplier<DuplicateValueException> duplicateElement(Object element) {
        return () -> new DuplicateValueException(DuplicateValueException.Usage.ELEMENT, element);
    }

    public static Supplier<DuplicateValueException> duplicateElement() {
        return () -> new DuplicateValueException(DuplicateValueException.Usage.ELEMENT);
    }

    public static Supplier<DuplicateValueException> duplicateValue(String message) {
        return () -> new DuplicateValueException(message);
    }
}

