/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.klojang.check.aux.Result;
import org.klojang.check.relation.ComposableIntPredicate;
import org.klojang.check.relation.ComposablePredicate;
import org.klojang.check.relation.IntObjRelation;
import org.klojang.check.relation.IntRelation;
import org.klojang.check.relation.Relation;
import org.klojang.check.x.CheckImpls;
import org.klojang.check.x.Misc;
import org.klojang.check.x.StringCheckImpls;

public final class CommonChecks {
    private CommonChecks() {
        throw new UnsupportedOperationException();
    }

    public static <T> ComposablePredicate<T> NULL() {
        return Objects::isNull;
    }

    public static <T> ComposablePredicate<T> notNull() {
        return Objects::nonNull;
    }

    public static ComposablePredicate<Boolean> yes() {
        return x -> x;
    }

    public static ComposablePredicate<Boolean> no() {
        return x -> x == false;
    }

    public static <T> ComposablePredicate<T> empty() {
        return CheckImpls::isEmpty;
    }

    public static ComposablePredicate<String> emptyString() {
        return s -> s == null || s.isEmpty();
    }

    public static <T> ComposablePredicate<T> notEmpty() {
        return CheckImpls::isNotEmpty;
    }

    public static <T> ComposablePredicate<T> deepNotNull() {
        return CheckImpls::isDeepNotNull;
    }

    public static <T> ComposablePredicate<T> deepNotEmpty() {
        return CheckImpls::isDeepNotEmpty;
    }

    public static ComposablePredicate<String> blank() {
        return s -> s == null || s.isBlank();
    }

    public static ComposablePredicate<String> plainInt() {
        return StringCheckImpls::isPlainInt;
    }

    public static ComposablePredicate<String> plainShort() {
        return StringCheckImpls::isPlainShort;
    }

    public static <T> ComposablePredicate<T> array() {
        return x -> x.getClass() == Class.class ? ((Class)x).isArray() : x.getClass().isArray();
    }

    public static ComposablePredicate<File> regularFile() {
        return f -> Files.isRegularFile(f.toPath(), new LinkOption[0]);
    }

    public static ComposablePredicate<File> directory() {
        return f -> Files.isDirectory(f.toPath(), new LinkOption[0]);
    }

    public static ComposablePredicate<File> symlink() {
        return f -> Files.isSymbolicLink(f.toPath());
    }

    public static ComposablePredicate<File> fileExists() {
        return File::exists;
    }

    public static ComposablePredicate<File> readable() {
        return File::canRead;
    }

    public static ComposablePredicate<File> writable() {
        return File::canWrite;
    }

    public static <T> ComposablePredicate<Optional<T>> present() {
        return Optional::isPresent;
    }

    public static <T> ComposablePredicate<Result<T>> available() {
        return Result::isAvailable;
    }

    public static ComposableIntPredicate even() {
        return x -> x % 2 == 0;
    }

    public static ComposableIntPredicate odd() {
        return x -> x % 2 == 1;
    }

    public static ComposableIntPredicate positive() {
        return x -> x > 0;
    }

    public static ComposableIntPredicate negative() {
        return x -> x < 0;
    }

    public static ComposableIntPredicate zero() {
        return x -> x == 0;
    }

    public static IntRelation eq() {
        return (x, y) -> x == y;
    }

    public static IntRelation ne() {
        return (x, y) -> x != y;
    }

    public static IntRelation gt() {
        return (x, y) -> x > y;
    }

    public static IntRelation gte() {
        return (x, y) -> x >= y;
    }

    public static IntRelation lt() {
        return (x, y) -> x < y;
    }

    public static IntRelation lte() {
        return (x, y) -> x <= y;
    }

    public static IntRelation multipleOf() {
        return (x, y) -> x % y == 0;
    }

    public static <S, O> Relation<S, O> EQ() {
        return Object::equals;
    }

    public static <T> Relation<T, T> equalTo() {
        return Object::equals;
    }

    public static <T extends Comparable<T>> Relation<T, T> GT() {
        return (x, y) -> x.compareTo(y) > 0;
    }

    public static <T extends Comparable<T>> Relation<T, T> LT() {
        return (x, y) -> x.compareTo(y) < 0;
    }

    public static <T extends Comparable<T>> Relation<T, T> GTE() {
        return (x, y) -> x.compareTo(y) >= 0;
    }

    public static <T extends Comparable<T>> Relation<T, T> LTE() {
        return (x, y) -> x.compareTo(y) <= 0;
    }

    public static <S, O> Relation<S, O> sameAs() {
        return (x, y) -> x == y;
    }

    public static <T> Relation<T, T> nullOr() {
        return (x, y) -> x == null || x.equals(y);
    }

    public static <S> Relation<S, Class<?>> instanceOf() {
        return (x, y) -> y.isInstance(x);
    }

    public static <S, O> Relation<Class<S>, Class<O>> supertypeOf() {
        return Class::isAssignableFrom;
    }

    public static <S, O> Relation<Class<S>, Class<O>> subtypeOf() {
        return (x, y) -> y.isAssignableFrom((Class<?>)x);
    }

    public static <O, S extends Collection<? super O>> Relation<S, O> contains() {
        return Collection::contains;
    }

    public static <O, S extends Map<? super O, ?>> Relation<S, O> containsKey() {
        return Map::containsKey;
    }

    public static <O, S extends Map<?, ? super O>> Relation<S, O> containsValue() {
        return Map::containsValue;
    }

    public static <S, O extends Collection<? super S>> Relation<S, O> in() {
        return (x, y) -> y.contains(x);
    }

    public static <S, O extends Collection<? super S>> Relation<S, O> elementOf() {
        return CommonChecks.in();
    }

    public static <S, O extends Map<? super S, ?>> Relation<S, O> keyIn() {
        return (x, y) -> y.containsKey(x);
    }

    public static <S, O extends Map<?, ? super S>> Relation<S, O> valueIn() {
        return (x, y) -> y.containsValue(x);
    }

    public static <O, S extends O> Relation<S, O[]> inArray() {
        return CheckImpls::inArray;
    }

    public static <E, C0 extends Collection<? super E>, C1 extends Collection<E>> Relation<C0, C1> containsAll() {
        return Collection::containsAll;
    }

    public static <E, C0 extends Collection<E>, C1 extends Collection<? super E>> Relation<C0, C1> containedIn() {
        return (x, y) -> y.containsAll((Collection<?>)x);
    }

    public static Relation<String, CharSequence> hasSubstring() {
        return String::contains;
    }

    public static Relation<String, String> substringOf() {
        return (x, y) -> y.contains((CharSequence)x);
    }

    public static Relation<String, String> startsWith() {
        return String::startsWith;
    }

    public static Relation<String, String> endsWith() {
        return String::endsWith;
    }

    public static Relation<String, Pattern> hasPattern() {
        return (string, pattern) -> pattern.matcher((CharSequence)string).matches();
    }

    public static Relation<String, Pattern> containsPattern() {
        return (string, pattern) -> pattern.matcher((CharSequence)string).find();
    }

    public static Relation<String, String> matches() {
        return (string, pattern) -> CommonChecks.hasPattern().exists((String)string, Pattern.compile(pattern));
    }

    public static Relation<String, String> containsMatch() {
        return (string, pattern) -> CommonChecks.containsPattern().exists((String)string, Pattern.compile(pattern));
    }

    public static <T extends Number> Relation<String, Class<T>> numerical() {
        return (x, y) -> {
            Predicate<String> p = StringCheckImpls.NUMERICALS.get(y);
            if (p != null) {
                return p.test((String)x);
            }
            throw Misc.typeNotSupported(y);
        };
    }

    public static <T extends Number> Relation<String, Class<T>> parsableAs() {
        return (x, y) -> {
            Predicate<String> p = StringCheckImpls.PARSABLES.get(y);
            if (p != null) {
                return p.test((String)x);
            }
            throw Misc.typeNotSupported(y);
        };
    }

    public static Relation<String, String> equalsIC() {
        return String::equalsIgnoreCase;
    }

    public static Relation<String, String> startsWithIC() {
        return (s, o) -> s.regionMatches(true, 0, (String)o, 0, o.length());
    }

    public static Relation<String, String> endsWithIC() {
        return (s, o) -> s.regionMatches(true, s.length() - o.length(), (String)o, 0, o.length());
    }

    public static Relation<String, String> hasSubstringIC() {
        return (s, o) -> CommonChecks.containsPattern().exists((String)s, Pattern.compile(o, 18));
    }

    public static <T> IntObjRelation<T> indexOf() {
        return CheckImpls::isIndexOf;
    }

    public static <T> IntObjRelation<T> indexExclusiveOf() {
        return CommonChecks.indexOf();
    }

    public static <T> IntObjRelation<T> indexInclusiveOf() {
        return CheckImpls::isIndexInclusiveOf;
    }

    public static IntObjRelation<int[]> inIntArray() {
        return (x, y) -> {
            for (int i : y) {
                if (x != i) continue;
                return true;
            }
            return false;
        };
    }
}

