/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.check;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.klojang.check.CommonExceptions;
import org.klojang.check.IntCheck;
import org.klojang.check.ObjectCheck;
import org.klojang.check.x.msg.CustomMsgFormatter;

public final class Check {
    private static final Function<String, IllegalArgumentException> DEF_EXC_FACTORY = CommonExceptions.ARGUMENT;

    private Check() {
        throw new UnsupportedOperationException();
    }

    private static NullPointerException argumentMustNotBeNull() {
        return new NullPointerException("argument must not be null");
    }

    private static NullPointerException argumentMustNotBeNull(String tag) {
        return new NullPointerException(tag + " must not be null");
    }

    public static IntCheck<IllegalArgumentException> that(int value) {
        return new IntCheck<IllegalArgumentException>(value, null, DEF_EXC_FACTORY);
    }

    public static <T> ObjectCheck<T, IllegalArgumentException> that(T value) {
        return new ObjectCheck<T, IllegalArgumentException>(value, null, DEF_EXC_FACTORY);
    }

    public static IntCheck<IllegalArgumentException> that(int value, String tag) {
        return new IntCheck<IllegalArgumentException>(value, tag, DEF_EXC_FACTORY);
    }

    public static <T> ObjectCheck<T, IllegalArgumentException> that(T value, String tag) {
        return new ObjectCheck<T, IllegalArgumentException>(value, tag, DEF_EXC_FACTORY);
    }

    public static <T> ObjectCheck<T, IllegalArgumentException> notNull(T value) throws NullPointerException {
        if (value != null) {
            return new ObjectCheck<T, IllegalArgumentException>(value, null, DEF_EXC_FACTORY);
        }
        throw Check.argumentMustNotBeNull();
    }

    public static <T> ObjectCheck<T, IllegalArgumentException> notNull(T value, String tag) throws NullPointerException {
        if (value != null) {
            return new ObjectCheck<T, IllegalArgumentException>(value, tag, DEF_EXC_FACTORY);
        }
        throw Check.argumentMustNotBeNull(tag);
    }

    public static <X extends Exception> IntCheck<X> on(Function<String, X> excFactory, int value) {
        return new IntCheck<X>(value, null, excFactory);
    }

    public static <T, X extends Exception> ObjectCheck<T, X> on(Function<String, X> excFactory, T value) {
        return new ObjectCheck<T, X>(value, null, excFactory);
    }

    public static <X extends Exception> IntCheck<X> on(Function<String, X> excFactory, int value, String tag) {
        return new IntCheck<X>(value, tag, excFactory);
    }

    public static <T, X extends Exception> ObjectCheck<T, X> on(Function<String, X> excFactory, T value, String tag) {
        return new ObjectCheck<T, X>(value, tag, excFactory);
    }

    public static void offsetLength(byte[] array, int offset, int length) {
        if (array == null) {
            throw Check.argumentMustNotBeNull("array");
        }
        if ((offset | length) < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static void offsetLength(int size, int offset, int length) {
        if ((size | offset | length) < 0 || size < offset + length) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static int fromTo(List<?> list, int fromIndex, int toIndex) {
        if (list == null) {
            throw Check.argumentMustNotBeNull("list");
        }
        if (fromIndex < 0 || toIndex < fromIndex || list.size() < toIndex) {
            throw new IndexOutOfBoundsException("from=" + fromIndex + ";to=" + toIndex + ";size=" + list.size());
        }
        return toIndex - fromIndex;
    }

    public static <T> int fromTo(T[] array, int fromIndex, int toIndex) {
        if (array == null) {
            throw Check.argumentMustNotBeNull("array");
        }
        if ((fromIndex | toIndex) < 0 || toIndex < fromIndex || array.length < toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return toIndex - fromIndex;
    }

    public static int fromTo(String string, int fromIndex, int toIndex) {
        if (string == null) {
            throw Check.argumentMustNotBeNull("string");
        }
        if ((fromIndex | toIndex) < 0 || toIndex < fromIndex || string.length() < toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return toIndex - fromIndex;
    }

    public static int fromTo(int size, int fromIndex, int toIndex) {
        if ((size | fromIndex | toIndex) < 0 || toIndex < fromIndex || size < toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return toIndex - fromIndex;
    }

    public static <T> T fail(String message, Object ... msgArgs) throws IllegalArgumentException {
        return Check.fail(DEF_EXC_FACTORY, message, msgArgs);
    }

    public static <T, X extends Throwable> T fail(Supplier<X> excFactory) throws X {
        throw (Throwable)excFactory.get();
    }

    public static <T, X extends Throwable> T fail(Function<String, X> excFactory, String message, Object ... msgArgs) throws X {
        if (msgArgs == null || message == null) {
            throw (Throwable)excFactory.apply(message);
        }
        throw (Throwable)excFactory.apply(CustomMsgFormatter.formatWithUserArgs(message, msgArgs));
    }
}

