/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeListener;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.net.URI;
import javax.inject.Provider;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.killbill.commons.metrics.MetricTag;
import org.killbill.commons.metrics.TimedResource;
import org.killbill.commons.skeleton.metrics.TimedResourceListener;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"fast"})
public class TestTimedResourceInterceptor {
    private MetricRegistry registry;
    private TestResource interceptedResource;

    @BeforeMethod
    public void setup() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestResourceModule()});
        this.registry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        this.interceptedResource = (TestResource)injector.getInstance(TestResource.class);
    }

    public void testResourceWithResponse() {
        Response response = this.interceptedResource.createOk();
        Assert.assertEquals((int)200, (int)response.getStatus());
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createOk.POST.2xx.200");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceSimpleTag() {
        Response response = this.interceptedResource.createOk("AUTHORIZE");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createOk.POST.AUTHORIZE.2xx.200");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceWithPropertyTag() {
        Response response = this.interceptedResource.createOk(new Payment("PURCHASE"));
        Assert.assertEquals((int)201, (int)response.getStatus());
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createOk.POST.PURCHASE.2xx.201");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceNullTag() {
        Response response = this.interceptedResource.createOk((String)null);
        Assert.assertEquals((int)200, (int)response.getStatus());
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createOk.POST.null.2xx.200");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceNullPropertyTag() {
        Response response = this.interceptedResource.createOk((Payment)null);
        Assert.assertEquals((int)201, (int)response.getStatus());
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createOk.POST.null.2xx.201");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceWithNullResponse() {
        Response response = this.interceptedResource.createNullResponse();
        Assert.assertNull((Object)response);
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createNullResponse.PUT.2xx.204");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceWithVoidResponse() {
        this.interceptedResource.createNullResponse();
        Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createNullResponse.PUT.2xx.204");
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    public void testResourceWithWebApplicationException() {
        try {
            this.interceptedResource.createWebApplicationException();
            Assert.fail();
        }
        catch (WebApplicationException e) {
            Timer timer = (Timer)this.registry.getTimers().get("kb_resource.path.createWebApplicationException.POST.4xx.404");
            Assert.assertNotNull((Object)timer);
            Assert.assertEquals((long)1L, (long)timer.getCount());
        }
    }

    public static class TestResourceModule
    extends AbstractModule {
        protected void configure() {
            this.bind(GuiceContainer.class);
            this.bind(TestResource.class).asEagerSingleton();
            this.bind(MetricRegistry.class).asEagerSingleton();
            TimedResourceListener timedResourceTypeListener = new TimedResourceListener((Provider)this.getProvider(GuiceContainer.class), (Provider)this.getProvider(MetricRegistry.class));
            this.bindListener(Matchers.any(), (TypeListener)timedResourceTypeListener);
        }
    }

    @Path(value="path")
    public static class TestResource {
        @TimedResource
        @POST
        public Response createOk() {
            return Response.ok().build();
        }

        @TimedResource
        @POST
        public Response createOk(@MetricTag(tag="transactionType") String type) {
            return Response.ok().build();
        }

        @TimedResource
        @POST
        public Response createOk(@MetricTag(tag="transactionType", property="type") Payment payment) {
            return Response.created((URI)URI.create("about:blank")).build();
        }

        @TimedResource
        @PUT
        public Response createNullResponse() {
            return null;
        }

        @TimedResource
        @PUT
        public void createVoidResponse() {
        }

        @TimedResource
        @POST
        public void createWebApplicationException() {
            throw new WebApplicationException(404);
        }
    }

    public static class Payment {
        private final String type;

        public Payment(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

