/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.skeleton.metrics.ResourceTimer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"fast"})
public class TestResourceTimer {
    private static final String RESOURCE_METRICS_PREFIX = "kb_resource";
    private MetricRegistry metricRegistry;

    @BeforeMethod
    public void setup() {
        this.metricRegistry = new MetricRegistry();
    }

    @Test
    public void testMetricName() {
        String resourcePath = "/1.0/kb/payments";
        String resourceName = "getPayment";
        String httpMethod = "GET";
        ResourceTimer resourceTimer = new ResourceTimer("/1.0/kb/payments", "getPayment", "GET", null, this.metricRegistry);
        resourceTimer.update(200, 1L, TimeUnit.MILLISECONDS);
        String expectedMetricName = this.expectedMetricName("/1.0/kb/payments", "getPayment", "GET", null, "2xx", 200);
        Timer timer = (Timer)this.metricRegistry.getMetrics().get(expectedMetricName);
        Assert.assertNotNull((Object)timer, (String)"Failed to create metric with expected name");
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }

    private String expectedMetricName(String resourcePath, String resourceName, String httpMethod, String tagsValues, String statusGroup, int status) {
        if (tagsValues == null || tagsValues.trim().isEmpty()) {
            return String.format("%s.%s.%s.%s.%s.%s", RESOURCE_METRICS_PREFIX, resourcePath, resourceName, httpMethod, statusGroup, status);
        }
        return String.format("%s.%s.%s.%s.%s.%s.%s", RESOURCE_METRICS_PREFIX, resourcePath, resourceName, httpMethod, tagsValues, statusGroup, status);
    }

    @Test
    public void testMetricNameWithTags() {
        String resourcePath = "/1.0/kb/payments";
        String resourceName = "create";
        String httpMethod = "POST";
        ImmutableMap tags = ImmutableMap.builder().put((Object)"transactionType", (Object)"AUTHORIZE").build();
        ResourceTimer resourceTimer = new ResourceTimer("/1.0/kb/payments", "create", "POST", (Map)tags, this.metricRegistry);
        resourceTimer.update(501, 1L, TimeUnit.MILLISECONDS);
        String expectedMetricName = this.expectedMetricName("/1.0/kb/payments", "create", "POST", "AUTHORIZE", "5xx", 501);
        Timer timer = (Timer)this.metricRegistry.getMetrics().get(expectedMetricName);
        Assert.assertNotNull((Object)timer, (String)("Failed to create metric with expected name: " + expectedMetricName));
        Assert.assertEquals((long)1L, (long)timer.getCount());
    }
}

