/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.killbill.commons.skeleton.modules.AbstractBaseServerModuleTest;
import org.killbill.commons.skeleton.modules.BaseServerModuleBuilder;
import org.killbill.commons.skeleton.modules.HelloModule;
import org.killbill.commons.skeleton.modules.JerseyBaseServerModule;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJerseyBaseServerModule
extends AbstractBaseServerModuleTest {
    @Test(groups={"slow"})
    public void testJerseyIntegration() throws Exception {
        BaseServerModuleBuilder builder = new BaseServerModuleBuilder();
        builder.addJaxrsResource("org.killbill.commons.skeleton.modules");
        Server server = this.startServer(new Module[]{builder.build(), new HelloModule()});
        AsyncHttpClient client = new AsyncHttpClient();
        ListenableFuture responseFuture = client.prepareGet("http://127.0.0.1:" + ((NetworkConnector)server.getConnectors()[0]).getPort() + "/hello/alhuile/").execute();
        String body = ((Response)responseFuture.get()).getResponseBody();
        Assert.assertEquals((String)body, (String)"Hello alhuile");
        server.stop();
    }

    @Test(groups={"fast"})
    public void testJerseyParams() throws Exception {
        BaseServerModuleBuilder builder1 = new BaseServerModuleBuilder();
        JerseyBaseServerModule module1 = (JerseyBaseServerModule)builder1.build();
        ImmutableMap jerseyParams1 = module1.getJerseyParams().build();
        Assert.assertEquals((int)jerseyParams1.size(), (int)1);
        Assert.assertEquals((String)((String)jerseyParams1.get("com.sun.jersey.config.feature.logging.DisableEntitylogging")), (String)"true");
        BaseServerModuleBuilder builder2 = new BaseServerModuleBuilder();
        builder2.addJerseyFilter("filter1").addJerseyFilter("filter2").addJerseyFilter("filter3");
        JerseyBaseServerModule module2 = (JerseyBaseServerModule)builder2.build();
        ImmutableMap jerseyParams2 = module2.getJerseyParams().build();
        Assert.assertEquals((int)jerseyParams2.size(), (int)3);
        Assert.assertEquals((String)((String)jerseyParams2.get("com.sun.jersey.spi.container.ContainerRequestFilters")), (String)"filter1;filter2;filter3");
        Assert.assertEquals((String)((String)jerseyParams2.get("com.sun.jersey.spi.container.ContainerResponseFilters")), (String)"filter3;filter2;filter1");
        Assert.assertEquals((String)((String)jerseyParams2.get("com.sun.jersey.config.feature.logging.DisableEntitylogging")), (String)"true");
        BaseServerModuleBuilder builder3 = new BaseServerModuleBuilder();
        builder3.addJerseyFilter("filter1").addJerseyFilter("filter2").addJerseyFilter("filter3");
        builder3.addJerseyParam("com.sun.jersey.spi.container.ContainerRequestFilters", "bar").addJerseyParam("foo", "qux");
        JerseyBaseServerModule module3 = (JerseyBaseServerModule)builder3.build();
        ImmutableMap jerseyParams3 = module3.getJerseyParams().build();
        Assert.assertEquals((int)jerseyParams3.size(), (int)4);
        Assert.assertEquals((String)((String)jerseyParams3.get("com.sun.jersey.spi.container.ContainerRequestFilters")), (String)"bar;filter1;filter2;filter3");
        Assert.assertEquals((String)((String)jerseyParams3.get("com.sun.jersey.spi.container.ContainerResponseFilters")), (String)"filter3;filter2;filter1");
        Assert.assertEquals((String)((String)jerseyParams3.get("com.sun.jersey.config.feature.logging.DisableEntitylogging")), (String)"true");
        Assert.assertEquals((String)((String)jerseyParams3.get("foo")), (String)"qux");
        BaseServerModuleBuilder builder4 = new BaseServerModuleBuilder();
        builder4.addJerseyParam("com.sun.jersey.spi.container.ContainerRequestFilters", "bar").addJerseyParam("com.sun.jersey.spi.container.ContainerResponseFilters", "bar2").addJerseyParam("com.sun.jersey.config.feature.logging.DisableEntitylogging", "false").addJerseyParam("foo", "qux");
        builder4.addJerseyFilter("filter1").addJerseyFilter("filter2").addJerseyFilter("filter3");
        JerseyBaseServerModule module4 = (JerseyBaseServerModule)builder4.build();
        ImmutableMap jerseyParams4 = module4.getJerseyParams().build();
        Assert.assertEquals((int)jerseyParams4.size(), (int)4);
        Assert.assertEquals((String)((String)jerseyParams4.get("com.sun.jersey.spi.container.ContainerRequestFilters")), (String)"bar;filter1;filter2;filter3");
        Assert.assertEquals((String)((String)jerseyParams4.get("com.sun.jersey.spi.container.ContainerResponseFilters")), (String)"bar2;filter3;filter2;filter1");
        Assert.assertEquals((String)((String)jerseyParams4.get("com.sun.jersey.config.feature.logging.DisableEntitylogging")), (String)"false");
        Assert.assertEquals((String)((String)jerseyParams4.get("foo")), (String)"qux");
    }
}

