/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import java.util.Properties;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigModule
extends AbstractModule {
    private final ConfigSource configSource;
    private final Iterable<Class> configs;

    public ConfigModule() {
        this(System.getProperties());
    }

    public ConfigModule(Properties properties) {
        this((Iterable<Class>)ImmutableList.of(), (ConfigSource)new SimplePropertyConfigSource(properties));
    }

    public ConfigModule(Class config) {
        this((Iterable<Class>)ImmutableList.of((Object)config));
    }

    public ConfigModule(Class ... configs) {
        this((Iterable<Class>)ImmutableList.copyOf((Object[])configs));
    }

    public ConfigModule(Iterable<Class> configs) {
        this(configs, (ConfigSource)new SimplePropertyConfigSource(System.getProperties()));
    }

    public ConfigModule(Iterable<Class> configs, ConfigSource configSource) {
        this.configs = configs;
        this.configSource = configSource;
    }

    protected void configure() {
        for (Class config : this.configs) {
            this.bind(config).toInstance(new ConfigurationObjectFactory(this.configSource).build(config));
        }
    }
}

