/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.skeleton.modules;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.EventListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.testng.Assert;

public abstract class AbstractBaseServerModuleTest {
    protected Server startServer(Module ... modules) throws Exception {
        final Injector injector = Guice.createInjector((Module[])modules);
        final Server server = new Server(this.getPort());
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.addEventListener((EventListener)new GuiceServletContextListener(){

            protected Injector getInjector() {
                return injector;
            }
        });
        servletContextHandler.addFilter(GuiceFilter.class, "/*", null);
        servletContextHandler.addServlet(DefaultServlet.class, "/");
        server.setHandler((Handler)servletContextHandler);
        server.start();
        Thread t = new Thread(){

            public void run() {
                try {
                    server.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Assert.assertTrue((boolean)server.isRunning());
        return server;
    }

    private int getPort() {
        int port;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            Assert.fail();
            return -1;
        }
        return port;
    }
}

