/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class LoggingOutputStream
extends OutputStream {
    private boolean hasBeenClosed = false;
    private byte[] buf;
    private int count;
    private int bufLength;
    public static final int DEFAULT_BUFFER_LENGTH = 2048;
    private final Logger logger;

    public LoggingOutputStream(Logger log) throws IllegalArgumentException {
        if (log == null) {
            throw new IllegalArgumentException("log == null");
        }
        this.logger = log;
        this.bufLength = 2048;
        this.buf = new byte[2048];
        this.count = 0;
    }

    public void close() {
        this.flush();
        this.hasBeenClosed = true;
    }

    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if ((char)b == '\r' || (char)b == '\n') {
            return;
        }
        if (this.count == this.bufLength) {
            int newBufLength = this.bufLength + 2048;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buf, 0, newBuf, 0, this.bufLength);
            this.buf = newBuf;
            this.bufLength = newBufLength;
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    public void flush() {
        if (this.count == 0) {
            return;
        }
        if (this.count == 1 && (char)this.buf[0] == '\n') {
            this.reset();
            return;
        }
        if (this.count == 1 && (char)this.buf[0] == '\r') {
            this.reset();
            return;
        }
        if (this.count == 2 && (char)this.buf[0] == '\r' && (char)this.buf[1] == '\n') {
            this.reset();
            return;
        }
        byte[] theBytes = new byte[this.count];
        System.arraycopy(this.buf, 0, theBytes, 0, this.count);
        this.logger.debug(new String(theBytes));
        this.reset();
    }

    private void reset() {
        this.count = 0;
    }
}

