/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import java.sql.SQLException;
import java.util.Properties;
import java.util.TreeMap;
import org.killbill.commons.utils.MapJoiner;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.MariaDbDataSource;

public class KillBillMariaDbDataSource
extends MariaDbDataSource {
    private static final MapJoiner mapJoiner = new MapJoiner("=", "&");
    private String url;
    private Boolean cachePrepStmts;
    private Integer prepStmtCacheSize;
    private Integer prepStmtCacheSqlLimit;
    private Boolean useServerPrepStmts;

    public void setUrl(String url) throws SQLException {
        this.url = url;
        this.updateUrlIfNeeded();
    }

    public void setCachePrepStmts(boolean cachePrepStmts) throws SQLException {
        this.cachePrepStmts = cachePrepStmts;
        this.updateUrlIfNeeded();
    }

    public void setPrepStmtCacheSize(int prepStmtCacheSize) throws SQLException {
        this.prepStmtCacheSize = prepStmtCacheSize;
        this.updateUrlIfNeeded();
    }

    public void setPrepStmtCacheSqlLimit(int prepStmtCacheSqlLimit) throws SQLException {
        this.prepStmtCacheSqlLimit = prepStmtCacheSqlLimit;
        this.updateUrlIfNeeded();
    }

    public void setUseServerPrepStmts(boolean useServerPrepStmts) throws SQLException {
        this.useServerPrepStmts = useServerPrepStmts;
        this.updateUrlIfNeeded();
    }

    private void updateUrlIfNeeded() throws SQLException {
        if (this.url != null) {
            this.url = this.buildUpdatedUrl(this.url);
            super.setUrl(this.url);
        }
    }

    @VisibleForTesting
    String buildUpdatedUrl(String url) throws SQLException {
        Properties propertyWithPermitMysqlScheme = new Properties();
        propertyWithPermitMysqlScheme.put("permitMysqlScheme", "true");
        String baseUrlWithPermitMysqlScheme = this.buildUpdatedUrl(url, propertyWithPermitMysqlScheme, true);
        Properties props = new Properties();
        Configuration.parse((String)baseUrlWithPermitMysqlScheme, (Properties)props);
        if (this.cachePrepStmts != null && !props.containsKey("cachePrepStmts")) {
            props.put("cachePrepStmts", this.cachePrepStmts);
        }
        if (this.prepStmtCacheSize != null && !props.containsKey("prepStmtCacheSize")) {
            props.put("prepStmtCacheSize", this.prepStmtCacheSize);
        }
        if (this.prepStmtCacheSqlLimit != null && !props.containsKey("prepStmtCacheSqlLimit")) {
            props.put("prepStmtCacheSqlLimit", this.prepStmtCacheSqlLimit);
        }
        if (this.useServerPrepStmts != null && !props.containsKey("useServerPrepStmts")) {
            props.put("useServerPrepStmts", this.useServerPrepStmts);
        }
        return this.buildUpdatedUrl(url, props, false);
    }

    private String buildUpdatedUrl(String url, Properties props, boolean append) {
        if (props.isEmpty()) {
            return url;
        }
        int separator = url.indexOf("//");
        String urlSecondPart = url.substring(separator + 2);
        int paramIndex = urlSecondPart.indexOf("?");
        if (append) {
            return url + (paramIndex > 0 ? "&" : "?") + mapJoiner.join(new TreeMap<Object, Object>(props));
        }
        String baseUrl = paramIndex > 0 ? url.substring(0, separator + 2 + paramIndex) : url;
        return baseUrl + "?" + mapJoiner.join(new TreeMap<Object, Object>(props));
    }
}

