/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.utils.Preconditions;
import org.killbill.testing.mysql.MySqlServerOptions;
import org.killbill.testing.mysql.TestingMySqlServer;
import org.mariadb.jdbc.MariaDbDataSource;

public class MySQLEmbeddedDB
extends EmbeddedDB {
    private final MySqlServerOptions options;
    private TestingMySqlServer mysqldResource;
    protected final AtomicBoolean started = new AtomicBoolean(false);

    public MySQLEmbeddedDB() {
        this("mydb_" + UUID.randomUUID().toString().substring(0, 8), "myuser_" + UUID.randomUUID().toString().substring(0, 8), "mypass_" + UUID.randomUUID().toString().substring(0, 8));
    }

    public MySQLEmbeddedDB(String databaseName, String username, String password) {
        super(databaseName, username, password, null);
        this.options = MySqlServerOptions.builder((String[])new String[]{databaseName}).setUsername(username).setPassword(password).build();
        this.jdbcConnectionString = this.options.getJdbcUrl(databaseName);
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.MYSQL;
    }

    public void initialize() throws IOException {
    }

    public void start() throws IOException, SQLException {
        if (this.started.get()) {
            throw new IOException("MySQL is already running: " + this.jdbcConnectionString);
        }
        try {
            this.mysqldResource = new TestingMySqlServer(this.options);
            this.started.set(true);
            logger.info("MySQL started: {}", (Object)this.getCmdLineConnectionString());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.createDataSource();
        this.refreshTableNames();
    }

    public void refreshTableNames() throws IOException {
        String query = String.format("select table_name from information_schema.tables where table_schema = '%s' and table_type = 'BASE TABLE';", this.databaseName);
        try {
            this.executeQuery(query, new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    MySQLEmbeddedDB.this.allTables.clear();
                    while (resultSet.next()) {
                        MySQLEmbeddedDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public DataSource getDataSource() throws IOException {
        if (!this.started.get()) {
            throw new IOException("MySQL is not running");
        }
        return super.getDataSource();
    }

    public void stop() throws IOException {
        if (!this.started.get()) {
            throw new IOException("MySQL is not running");
        }
        super.stop();
        this.stopMysql();
    }

    public String getCmdLineConnectionString() {
        Preconditions.checkState((boolean)this.started.get(), (Object)"MySQL isn't running");
        Preconditions.checkNotNull((Object)this.mysqldResource);
        return String.format("mysql -u%s -p%s -P%s -S%s/mysql.sock %s", this.username, this.password, this.options.getPort(), this.mysqldResource.getServerDirectory(), this.databaseName);
    }

    protected void createDataSource() throws IOException, SQLException {
        Preconditions.checkState((boolean)this.started.get(), (Object)"MySQL isn't running");
        if (this.useConnectionPooling()) {
            this.dataSource = this.createHikariDataSource();
        } else {
            MariaDbDataSource mariaDBDataSource = new MariaDbDataSource();
            try {
                mariaDBDataSource.setUrl(this.jdbcConnectionString);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            mariaDBDataSource.setUser(this.username);
            mariaDBDataSource.setPassword(this.password);
            this.dataSource = mariaDBDataSource;
        }
    }

    private void stopMysql() {
        if (this.mysqldResource != null) {
            try {
                this.mysqldResource.close();
            }
            catch (NullPointerException npe) {
                logger.warn("Failed to shutdown mysql properly ", (Throwable)npe);
            }
            this.started.set(false);
            logger.info("MySQL stopped");
        }
    }
}

