/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.mysql;

import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.command.Command;
import io.airlift.command.CommandFailedException;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackedEmbeddedMySql
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HackedEmbeddedMySql.class);
    private static final String JDBC_FORMAT = "jdbc:mysql://localhost:%s/%s?user=%s&useSSL=false";
    private static final Duration STARTUP_WAIT = new Duration(10.0, TimeUnit.SECONDS);
    private static final Duration SHUTDOWN_WAIT = new Duration(10.0, TimeUnit.SECONDS);
    private static final Duration COMMAND_TIMEOUT = new Duration(30.0, TimeUnit.SECONDS);
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"testing-mysql-server-%s"));
    private final Path serverDirectory;
    private final int port;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Process mysqld;

    public HackedEmbeddedMySql(int port) throws IOException {
        this.port = port;
        this.serverDirectory = Files.createTempDirectory("testing-mysql-server", new FileAttribute[0]);
        log.info("Starting MySQL server in {}", (Object)this.serverDirectory);
        try {
            this.unpackMySql(this.serverDirectory);
            this.initialize();
            this.mysqld = this.startMysqld();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public Path getServerDirectory() {
        return this.serverDirectory;
    }

    public String getJdbcUrl(String userName, String dbName) {
        return String.format(JDBC_FORMAT, this.port, dbName, userName);
    }

    public int getPort() {
        return this.port;
    }

    public Connection getMySqlDatabase() throws SQLException {
        return DriverManager.getConnection(this.getJdbcUrl("root", "mysql"));
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.mysqld != null) {
            log.info("Shutting down mysqld. Waiting up to {} for shutdown to finish.", (Object)STARTUP_WAIT);
            this.mysqld.destroyForcibly();
            try {
                this.mysqld.waitFor(SHUTDOWN_WAIT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.mysqld.isAlive()) {
                log.error("mysqld is still running in {}", (Object)this.serverDirectory);
            }
        }
        try {
            MoreFiles.deleteRecursively((Path)this.serverDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            log.warn("Failed to delete {}", (Object)this.serverDirectory, (Object)e);
        }
        this.executor.shutdownNow();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serverDirectory", (Object)this.serverDirectory).add("port", this.port).toString();
    }

    public static int randomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private void initialize() {
        this.system(this.mysqld(), "--no-defaults", "--initialize-insecure", "--innodb-flush-method=nosync", "--datadir", this.dataDir());
    }

    private Process startMysqld() throws IOException {
        ArrayList args = Lists.newArrayList((Object[])new String[]{this.mysqld(), "--no-defaults", "--skip-ssl", "--skip-mysqlx", "--explicit_defaults_for_timestamp", "--innodb-flush-method=nosync", "--innodb-flush-log-at-trx-commit=0", "--innodb-doublewrite=0", "--bind-address=localhost", "--lc_messages_dir", this.serverDirectory.resolve("share").toString(), "--socket", this.serverDirectory.resolve("mysql.sock").toString(), "--port", String.valueOf(this.port), "--datadir", this.dataDir()});
        Process process = new ProcessBuilder(args).redirectErrorStream(true).start();
        log.info("mysqld started on port {}. Waiting up to {} for startup to finish.", (Object)this.port, (Object)STARTUP_WAIT);
        this.startOutputProcessor(process.getInputStream());
        this.waitForServerStartup(process);
        return process;
    }

    private String mysqld() {
        return this.serverDirectory.resolve("bin").resolve("mysqld").toString();
    }

    private String dataDir() {
        return this.serverDirectory.resolve("data").toString();
    }

    private void waitForServerStartup(Process process) throws IOException {
        SQLException lastCause = null;
        long start = System.nanoTime();
        while (Duration.nanosSince((long)start).compareTo(STARTUP_WAIT) <= 0) {
            try {
                this.checkReady();
                log.info("mysqld startup finished");
                return;
            }
            catch (SQLException e) {
                lastCause = e;
                try {
                    int value = process.exitValue();
                    throw new IOException(String.format("mysqld exited with value %s, check stdout for more detail", value));
                }
                catch (IllegalThreadStateException value) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
        throw new IOException("mysqld failed to start after " + STARTUP_WAIT, lastCause);
    }

    private void checkReady() throws SQLException {
        try (Connection connection = this.getMySqlDatabase();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT 42");){
            HackedEmbeddedMySql.checkSql(resultSet.next(), "no rows in result set");
            HackedEmbeddedMySql.checkSql(resultSet.getInt(1) == 42, "wrong result");
            HackedEmbeddedMySql.checkSql(!resultSet.next(), "multiple rows in result set");
        }
    }

    private static void checkSql(boolean expression, String message) throws SQLException {
        if (!expression) {
            throw new SQLException(message);
        }
    }

    private void startOutputProcessor(InputStream in) {
        this.executor.execute(() -> {
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void system(String ... command) {
        try {
            new Command(command).setTimeLimit(COMMAND_TIMEOUT).execute((Executor)this.executor);
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackMySql(Path target) throws IOException {
        String archiveName = String.format("/mysql-%s.tar.gz", HackedEmbeddedMySql.getPlatform());
        URL url = HackedEmbeddedMySql.class.getResource(archiveName);
        if (url == null) {
            throw new RuntimeException("archive not found: " + archiveName);
        }
        File archive = File.createTempFile("mysql-", null);
        try {
            try (InputStream in = url.openStream();){
                Files.copy(in, archive.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.system("tar", "-xzf", archive.getPath(), "-C", target.toString());
        }
        finally {
            if (!archive.delete()) {
                log.warn("Failed to delete file {}", (Object)archive);
            }
        }
    }

    private static String getPlatform() {
        return (StandardSystemProperty.OS_NAME.value() + "-" + StandardSystemProperty.OS_ARCH.value()).replace(' ', '_');
    }
}

