/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.jdbc.Driver;
import com.mysql.management.HackedInitializeUser;
import com.mysql.management.HelpOptionsParser;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.CommandLineOptionsParser;
import com.mysql.management.util.ListToString;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.ProcessUtil;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Threads;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;

public final class HackedMysqldResource
implements MysqldResourceI {
    public static final String MYSQL_C_MXJ = "mysql-c.mxj";
    public static final String DATA = "data";
    private String versionString;
    private Map options;
    private Shell shell;
    private final File baseDir;
    private final File dataDir;
    private final File pidFile;
    private final File portFile;
    private String msgPrefix;
    private String pid;
    private Properties platformProperties;
    private Properties connectorMxjProperties;
    private String osName_osArch;
    private PrintStream out;
    private PrintStream err;
    private PrintStream debug;
    private Exception trace;
    private int killDelay;
    private List completionListensers;
    private boolean readyForConnections;
    private String windowsKillCommand;
    private HelpOptionsParser optionParser;
    private Utils utils;

    public HackedMysqldResource() {
        this(null, null, null, null, null, null);
    }

    public HackedMysqldResource(File baseDir) {
        this(baseDir, null, null, null, null, null);
    }

    public HackedMysqldResource(File baseDir, File dataDir) {
        this(baseDir, dataDir, null, null, null, null);
    }

    public HackedMysqldResource(File baseDir, File dataDir, String mysqlVersionString) {
        this(baseDir, dataDir, mysqlVersionString, null, null, null);
    }

    public HackedMysqldResource(File baseDir, File dataDir, String mysqlVersionString, PrintStream out, PrintStream err, PrintStream debug) {
        this(baseDir, dataDir, mysqlVersionString, out, err, debug, null);
    }

    HackedMysqldResource(File pBaseDir, File pDataDir, String pMysqlVersionString, PrintStream pOut, PrintStream pErr, PrintStream pDebug, Utils pUtils) {
        this.out = pOut != null ? pOut : System.out;
        this.err = pErr != null ? pErr : System.err;
        this.debug = pDebug != null ? pDebug : this.out;
        this.utils = pUtils != null ? pUtils : new Utils();
        this.platformProperties = this.utils.streams().loadProperties("platform-map.properties", pErr);
        this.connectorMxjProperties = this.utils.streams().loadProperties("connector-mxj.properties", pErr);
        this.baseDir = this.utils.files().validCononicalDir(pBaseDir, this.utils.files().tmp(MYSQL_C_MXJ));
        this.dataDir = this.utils.files().validCononicalDir(pDataDir, new File(this.baseDir, DATA));
        this.optionParser = new HelpOptionsParser(this.err, this.utils);
        this.killDelay = this.getKillDelyFromProperties(this.connectorMxjProperties);
        this.windowsKillCommand = this.getWindowsKillCommand(this.connectorMxjProperties);
        String className = this.utils.str().shortClassName(this.getClass());
        this.pidFile = this.utils.files().cononical(new File(this.dataDir, className + ".pid"));
        this.portFile = new File(this.dataDir, className + ".port");
        this.setVersion(false, pMysqlVersionString);
        this.msgPrefix = "[" + className + "] ";
        this.options = new HashMap();
        this.setShell(null);
        this.setOsAndArch(System.getProperty("os.name"), System.getProperty("os.arch"));
        this.completionListensers = new ArrayList();
        this.initTrace();
    }

    private void initTrace() {
        this.trace = new Exception();
    }

    public synchronized void start(String threadName, Map mysqldArgs) {
        this.start(threadName, mysqldArgs, false);
    }

    public synchronized void start(String threadName, Map pMysqldArgs, boolean populateAllOptions) {
        if (this.getShell() != null || this.processRunning()) {
            this.printMessage("mysqld already running (process: " + this.pid() + ")");
            return;
        }
        HashMap<String, String> mysqldArgs = new HashMap<String, String>(pMysqldArgs);
        int port = this.parseInt(mysqldArgs.get("port"), 3306);
        mysqldArgs.put("port", "" + port);
        mysqldArgs.remove("mysql-version");
        String initUserProp = (String)mysqldArgs.remove("initialize-user");
        boolean initUser = Boolean.valueOf(initUserProp);
        String user = (String)mysqldArgs.remove("initialize-user.user");
        String password = (String)mysqldArgs.remove("initialize-user.password");
        this.setKillDelay(this.parseInt(mysqldArgs.remove("kill-delay"), this.killDelay));
        if (populateAllOptions) {
            this.options = this.optionParser.getOptionsFromHelp(this.getHelp(mysqldArgs));
        } else {
            this.options = new HashMap();
            this.options.putAll(mysqldArgs);
        }
        this.out.flush();
        this.addCompletionListenser(new Runnable(){

            @Override
            public void run() {
                HackedMysqldResource.this.setReadyForConnection(false);
                HackedMysqldResource.this.setShell(null);
                HackedMysqldResource.this.completionListensers.remove(this);
            }
        });
        this.setShell(this.exec(threadName, mysqldArgs, this.out, this.debug, true));
        this.reportPid();
        this.utils.files().writeString(this.portFile, port + this.utils.str().newLine());
        boolean ready = this.canConnectToServer(port, this.killDelay);
        this.setReadyForConnection(ready);
        if (initUser) {
            try {
                new HackedInitializeUser(port, user, password, this.err).initializeUser();
            }
            catch (Throwable t) {
                t.printStackTrace(this.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canConnectToServer(int port, int milisecondsBeforeGivingUp) {
        int triesBeforeGivingUp = 1 + milisecondsBeforeGivingUp / 1000 * 4;
        this.utils.str().classForName(Driver.class.getName());
        Connection conn = null;
        String bogusUser = "Connector/MXJ";
        String password = "Bogus Password";
        String url = "jdbc:mysql://127.0.0.1:" + port + "/test?connectTimeout=150";
        for (int i = 0; i < triesBeforeGivingUp; ++i) {
            try {
                conn = DriverManager.getConnection(url, bogusUser, password);
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1045 || e.getMessage().startsWith("Could not connect: Access denied")) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(this.err);
                }
            }
            this.utils.threads().pause(100);
        }
        return false;
    }

    private void setReadyForConnection(boolean ready) {
        this.readyForConnections = ready;
    }

    public synchronized boolean isReadyForConnections() {
        return this.readyForConnections;
    }

    private void reportPid() {
        int CYCLES = 100;
        int CYCLE_DELAY = this.killDelay / 100;
        boolean printed = false;
        for (int i = 0; !printed && i < 100; ++i) {
            if (this.pidFile.exists() && this.pidFile.length() > 0L) {
                this.utils.threads().pause(100);
                this.printMessage("mysqld running as process: " + this.pid());
                this.out.flush();
                printed = true;
            }
            this.utils.threads().pause(CYCLE_DELAY);
        }
        this.reportIfNoPidfile(printed);
    }

    synchronized String pid() {
        if (this.pid == null) {
            if (!this.pidFile.exists()) {
                return "No PID";
            }
            this.pid = this.utils.files().asString(this.pidFile).trim();
        }
        return this.pid;
    }

    void reportIfNoPidfile(boolean pidFileFound) {
        if (!pidFileFound) {
            this.printWarning("mysqld pid-file not found:  " + this.pidFile);
        }
    }

    public synchronized void shutdown() {
        boolean haveShell;
        boolean bl = haveShell = this.getShell() != null;
        if (!this.pidFile.exists() && !haveShell) {
            this.printMessage("Mysqld not running. No file: " + this.pidFile);
            return;
        }
        this.printMessage("stopping mysqld (process: " + this.pid() + ")");
        this.issueNormalKill();
        if (this.processRunning()) {
            this.issueForceKill();
        }
        if (this.shellRunning()) {
            this.destroyShell();
        }
        this.setShell(null);
        if (this.processRunning()) {
            this.printWarning("Process " + this.pid + "still running; not deleting " + this.pidFile);
        } else {
            this.utils.threads().pause(150);
            this.pidFile.delete();
            this.pid = null;
            this.portFile.delete();
            this.utils.threads().pause(150);
            if (this.pidFile.exists()) {
                this.printMessage(this.pidFile + " still exits.");
            }
            if (this.portFile.exists()) {
                this.printMessage(this.portFile + " still exits.");
            }
        }
        this.setReadyForConnection(false);
        if (!this.options.isEmpty()) {
            this.printMessage("clearing options");
            this.options.clear();
        }
        this.printMessage("shutdown complete");
        this.out.flush();
    }

    void destroyShell() {
        String shellName = this.getShell().getName();
        this.printWarning("attempting to destroy thread " + shellName);
        this.getShell().destroyProcess();
        this.waitForShellToDie();
        String msg = (this.shellRunning() ? "not " : "") + "destroyed.";
        this.printWarning(shellName + " " + msg);
    }

    void issueForceKill() {
        this.printWarning("attempting to \"force kill\" " + this.pid());
        new ProcessUtil(this.pid(), this.err, this.err, this.baseDir, this.utils, this.windowsKillCommand).forceKill();
        this.waitForProcessToDie();
        if (this.processRunning()) {
            String msg = (this.processRunning() ? "not " : "") + "killed.";
            this.printWarning(this.pid() + " " + msg);
        } else {
            this.printMessage("force kill " + this.pid() + " issued.");
        }
    }

    private void issueNormalKill() {
        if (!this.pidFile.exists()) {
            this.printWarning("Not running? File not found: " + this.pidFile);
            return;
        }
        new ProcessUtil(this.pid(), this.err, this.err, this.baseDir, this.utils, this.windowsKillCommand).killNoThrow();
        this.waitForProcessToDie();
    }

    private void waitForProcessToDie() {
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        while (this.processRunning() && System.currentTimeMillis() < giveUp) {
            this.utils.threads().pause(250);
        }
    }

    private void waitForShellToDie() {
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        while (this.shellRunning() && System.currentTimeMillis() < giveUp) {
            this.utils.threads().pause(250);
        }
    }

    public synchronized Map getServerOptions() {
        if (this.options.isEmpty()) {
            this.options = this.optionParser.getOptionsFromHelp(this.getHelp(new HashMap()));
            this.options.put("basedir", this.baseDir.getPath());
            this.options.put("datadir", this.dataDir.getPath());
        }
        return new HashMap(this.options);
    }

    public synchronized boolean isRunning() {
        return this.shellRunning() || this.processRunning();
    }

    private boolean processRunning() {
        if (!this.pidFile.exists()) {
            return false;
        }
        return new ProcessUtil(this.pid(), this.out, this.err, this.baseDir, this.utils, this.windowsKillCommand).isRunning();
    }

    private boolean shellRunning() {
        return this.getShell() != null && this.getShell().isAlive();
    }

    public synchronized String getVersion() {
        return this.versionString;
    }

    private String getVersionDir() {
        return this.getVersion().replaceAll("\\.", "-");
    }

    private synchronized void setVersion(boolean checkRunning, String mysqlVersionString) {
        if (checkRunning && this.isRunning()) {
            throw new IllegalStateException("Already running");
        }
        this.versionString = mysqlVersionString == null || mysqlVersionString.equals("") ? System.getProperty("mysql-version", this.connectorMxjProperties.getProperty("mysql-version")) + "" : mysqlVersionString;
        this.versionString = this.versionString.trim();
    }

    public synchronized void setVersion(String mysqlVersionString) {
        this.setVersion(true, mysqlVersionString);
    }

    private void printMessage(String msg) {
        this.println(this.out, msg);
    }

    private void printWarning(String msg) {
        this.println(this.err, "");
        this.println(this.err, msg);
    }

    private void println(PrintStream stream, String msg) {
        stream.println(this.msgPrefix + msg);
    }

    final String getWindowsKillCommand(Properties props) {
        String key = "windows-kill-command";
        String defaultVal = "kill.exe";
        String fileVal = props.getProperty(key, defaultVal);
        String val = System.getProperty(key, fileVal).trim();
        return val.length() > 0 ? val : defaultVal;
    }

    final void setOsAndArch(String osName, String osArch) {
        String key = this.stripUnwantedChars(osName + "-" + osArch);
        this.osName_osArch = this.platformProperties.getProperty(key, key);
    }

    String stripUnwantedChars(String str) {
        return str.replace(' ', '_').replace('/', '_').replace('\\', '_');
    }

    private Shell exec(String threadName, Map mysqldArgs, PrintStream outStream, PrintStream errStream, boolean withListeners) {
        this.deployFiles();
        this.adjustParameterMap(mysqldArgs);
        Object[] args = this.constructArgs(mysqldArgs);
        outStream.println(new ListToString().toString(args));
        Shell launch = this.utils.shellFactory().newShell((String[])args, threadName, outStream, errStream);
        if (withListeners) {
            for (int i = 0; i < this.completionListensers.size(); ++i) {
                Runnable listener = (Runnable)this.completionListensers.get(i);
                launch.addCompletionListener(listener);
            }
        }
        launch.setDaemon(true);
        this.printMessage("launching mysqld (" + threadName + ")");
        launch.start();
        return launch;
    }

    public void deployFiles() {
        this.makeMysqld();
        this.ensureEssentialFilesExist();
        try {
            this.makeMysqlClient();
        }
        catch (MissingResourceException e) {
            this.printMessage(e.getMessage() + " - OK.");
        }
    }

    private void adjustParameterMap(Map mysqldArgs) {
        this.ensureDir(mysqldArgs, this.baseDir, "basedir");
        this.ensureDir(mysqldArgs, this.dataDir, "datadir");
        mysqldArgs.put("pid-file", this.pidFile.getPath());
        this.ensureSocket(mysqldArgs);
    }

    File makeMysqld() {
        return this.extractExecutable(this.executableName());
    }

    File makeMysqlClient() {
        return this.extractExecutable(this.clientExecutableName());
    }

    private File extractExecutable(String executableName) {
        File executable = new File(this.binDir(), executableName);
        if (!executable.exists()) {
            executable.getParentFile().mkdirs();
            String resource = this.getResourceName(executableName);
            this.utils.streams().createFileFromResource(resource, executable);
        }
        this.utils.files().addExecutableRights(executable, this.out, this.err);
        return executable;
    }

    String getResourceName() {
        return this.getResourceName(this.executableName());
    }

    private String getResourceName(String name) {
        String dir = this.os_arch();
        return this.getVersionDir() + "/" + dir + "/" + name;
    }

    String os_arch() {
        return this.osName_osArch;
    }

    private String executableName() {
        if (!this.isWindows()) {
            return "mysqld";
        }
        String key = "windows-mysqld-command";
        String defaultValue = "mysqld.exe";
        return this.connectorMxjProperties.getProperty(key, defaultValue);
    }

    private String clientExecutableName() {
        if (this.isWindows()) {
            return "mysql.exe";
        }
        return "mysql";
    }

    boolean isWindows() {
        return this.osName_osArch.startsWith("Win");
    }

    File getMysqldFilePointer() {
        return new File(this.binDir(), this.executableName());
    }

    private File binDir() {
        return new File(this.baseDir, "bin");
    }

    void ensureEssentialFilesExist() {
        if (this.utils.files().isEmpty(this.dataDir)) {
            String data_jar = this.getVersionDir() + "/" + "data_dir.jar";
            this.utils.streams().expandResourceJar(this.dataDir, data_jar);
        }
        this.utils.streams().expandResourceJar(this.baseDir, this.getVersionDir() + "/" + this.shareJar());
    }

    void ensureSocket(Map mysqldArgs) {
        String socketString = (String)mysqldArgs.get("socket");
        if (socketString != null) {
            return;
        }
        mysqldArgs.put("socket", "mysql.sock");
    }

    private void ensureDir(Map mysqldArgs, File expected, String key) {
        File asConnonical;
        String dirString = (String)mysqldArgs.get(key);
        if (dirString != null && !expected.equals(asConnonical = this.utils.files().validCononicalDir(new File(dirString)))) {
            String msg = dirString + " not equal to " + expected;
            throw new IllegalArgumentException(msg);
        }
        mysqldArgs.put(key, this.utils.files().getPath(expected));
    }

    String[] constructArgs(Map mysqldArgs) {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.utils.files().getPath(this.getMysqldFilePointer()));
        strs.add("--no-defaults");
        if (this.isWindows()) {
            strs.add("--console");
        }
        for (Map.Entry entry : mysqldArgs.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            StringBuffer buf = new StringBuffer("--");
            buf.append(key);
            if (value != null) {
                buf.append("=");
                buf.append(value);
            }
            strs.add(buf.toString());
        }
        return this.utils.str().toStringArray(strs);
    }

    protected void finalize() throws Throwable {
        if (this.getShell() != null) {
            this.printWarning("resource released without closure.");
            this.trace.printStackTrace(this.err);
        }
        super.finalize();
    }

    String shareJar() {
        String shareJar = "share_dir.jar";
        if (this.isWindows()) {
            String key = "windows-share-dir-jar";
            String defaultVal = "win_" + shareJar;
            shareJar = this.connectorMxjProperties.getProperty(key, defaultVal);
        }
        return shareJar;
    }

    void setShell(Shell shell) {
        this.shell = shell;
    }

    Shell getShell() {
        return this.shell;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    int getKillDelyFromProperties(Properties props) {
        int defaultDelayFiveMinutes = 300000;
        String key = "kill-delay";
        String propsVal = props.getProperty("kill-delay", "300000");
        String sysProp = System.getProperty("kill-delay", propsVal);
        return this.parseInt(sysProp, 300000);
    }

    public synchronized void setKillDelay(int millis) {
        this.killDelay = millis;
    }

    public synchronized void addCompletionListenser(Runnable listener) {
        this.completionListensers.add(listener);
    }

    private String getHelp(Map params) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream capturedOut = new PrintStream(bos);
        params.put("help", null);
        params.put("verbose", null);
        this.exec("getOptions", params, capturedOut, capturedOut, false).join();
        params.remove("help");
        params.remove("verbose");
        this.utils.threads().pause(500);
        capturedOut.flush();
        capturedOut.close();
        return new String(bos.toByteArray());
    }

    public synchronized int getPort() {
        boolean defaultVal = false;
        if (this.isRunning() && this.portFile.exists()) {
            return this.parseInt(this.utils.files().asString(this.portFile), 0);
        }
        return 0;
    }

    int parseInt(Object parseMe, int defaultVal) {
        return this.utils.str().parseInt(parseMe, defaultVal, this.err);
    }

    static void printUsage(PrintStream out) {
        String command = "java " + MysqldResource.class.getName();
        String basedir = " --basedir";
        String datadir = " --datadir";
        out.println("Usage to start: ");
        out.println(command + " [ server options ]");
        out.println();
        out.println("Usage to shutdown: ");
        out.println(command + " --shutdown [" + basedir + "=/full/path/to/basedir ]");
        out.println();
        out.println("Common server options include:");
        out.println(basedir + "=/full/path/to/basedir");
        out.println(datadir + "=/full/path/to/datadir");
        out.println(" --socket=/full/path/to/socketfile");
        out.println();
        out.println("Example:");
        out.println(command + basedir + "=/home/duke/dukeapp/db" + datadir + "=/data/dukeapp/data --max_allowed_packet=65000000");
        out.println(command + " --shutdown" + basedir + "=/home/duke/dukeapp/db");
        out.println();
    }

    public static void main(String[] args) {
        CommandLineOptionsParser clop = new CommandLineOptionsParser(args);
        if (clop.containsKey("help")) {
            HackedMysqldResource.printUsage(System.out);
            return;
        }
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (clop.containsKey("silent")) {
            clop.remove("silent");
            NullPrintStream devNull = new NullPrintStream();
            out = devNull;
            err = devNull;
        }
        MysqldResource mysqld = new MysqldResource(clop.getBaseDir(), clop.getDataDir(), clop.getVersion(), out, err);
        Integer newKillDelay = clop.getKillDelay(err);
        if (newKillDelay != null) {
            mysqld.setKillDelay(newKillDelay.intValue());
        }
        if (clop.isShutdown()) {
            mysqld.shutdown();
            return;
        }
        mysqld.start(new Threads().newName(), clop.asMap());
    }
}

