/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import com.mysql.management.HackedMysqldResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.mysql.LoggingOutputStream;
import org.mariadb.jdbc.MySQLDataSource;

public class MySQLEmbeddedDB
extends EmbeddedDB {
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected DataSource dataSource;
    protected int port = this.getPort();
    private File dbDir;
    private File dataDir;
    private HackedMysqldResource mysqldResource;

    public MySQLEmbeddedDB() {
        this("database" + UUID.randomUUID().toString().substring(0, 8), "user" + UUID.randomUUID().toString().substring(0, 8), "pass" + UUID.randomUUID().toString().substring(0, 8));
    }

    public MySQLEmbeddedDB(String databaseName, String username, String password) {
        super(databaseName, username, password, null);
        this.jdbcConnectionString = "jdbc:mysql://localhost:" + this.port + "/" + databaseName + "?createDatabaseIfNotExist=true&allowMultiQueries=true";
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.MYSQL;
    }

    public void initialize() throws IOException {
    }

    public void start() throws IOException {
        if (this.started.get()) {
            throw new IOException("MySQL is already running: " + this.jdbcConnectionString);
        }
        this.startMysql();
        this.createDataSource();
        this.refreshTableNames();
    }

    public void refreshTableNames() throws IOException {
        String query = String.format("select table_name from information_schema.tables where table_schema = '%s' and table_type = 'BASE TABLE';", this.databaseName);
        try {
            this.executeQuery(query, new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    MySQLEmbeddedDB.this.allTables.clear();
                    while (resultSet.next()) {
                        MySQLEmbeddedDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public DataSource getDataSource() throws IOException {
        if (!this.started.get()) {
            throw new IOException("MySQL is not running");
        }
        return this.dataSource;
    }

    public void stop() throws IOException {
        if (!this.started.get()) {
            throw new IOException("MySQL is not running");
        }
        super.stop();
        this.stopMysql();
    }

    public String getCmdLineConnectionString() {
        return String.format("mysql -u%s -p%s -P%s -S%s/mysql.sock %s", this.username, this.password, this.port, this.dataDir, this.databaseName);
    }

    protected void createDataSource() throws IOException {
        if (this.useConnectionPooling()) {
            this.dataSource = this.createHikariDataSource();
        } else {
            MySQLDataSource mariaDBDataSource = new MySQLDataSource();
            try {
                mariaDBDataSource.setURL(this.jdbcConnectionString);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            mariaDBDataSource.setDatabaseName(this.databaseName);
            mariaDBDataSource.setUser(this.username);
            mariaDBDataSource.setPassword(this.password);
            mariaDBDataSource.setPort(this.port);
            this.dataSource = mariaDBDataSource;
        }
    }

    private void startMysql() throws IOException {
        this.dbDir = File.createTempFile("mysqldb", "");
        if (!this.dbDir.delete()) {
            logger.warn("Unable to delete " + this.dbDir.getAbsolutePath());
        }
        if (!this.dbDir.mkdir()) {
            throw new IOException("Unable to create " + this.dbDir.getAbsolutePath());
        }
        this.dataDir = File.createTempFile("mysqldata", "");
        if (!this.dataDir.delete()) {
            logger.warn("Unable to delete " + this.dataDir.getAbsolutePath());
        }
        if (!this.dataDir.mkdir()) {
            throw new IOException("Unable to create " + this.dataDir.getAbsolutePath());
        }
        PrintStream out = new PrintStream(new LoggingOutputStream(logger), true);
        this.mysqldResource = new HackedMysqldResource(this.dbDir, this.dataDir, null, out, out);
        HashMap<String, String> dbOpts = new HashMap<String, String>();
        dbOpts.put("port", Integer.toString(this.port));
        dbOpts.put("initialize-user", "true");
        dbOpts.put("initialize-user.password", this.password);
        dbOpts.put("initialize-user.user", this.username);
        dbOpts.put("default-time-zone", "+00:00");
        this.mysqldResource.start("test-mysqld-thread", dbOpts);
        if (!this.mysqldResource.isRunning()) {
            throw new IllegalStateException("MySQL did not start.");
        }
        this.started.set(true);
        logger.info("MySQL started: " + this.getCmdLineConnectionString());
    }

    private void stopMysql() throws IOException {
        if (this.mysqldResource != null) {
            try {
                this.mysqldResource.shutdown();
            }
            catch (NullPointerException npe) {
                logger.warn("Failed to shutdown mysql properly ", (Throwable)npe);
            }
            try {
                MySQLEmbeddedDB.deleteRecursive(this.dataDir);
                MySQLEmbeddedDB.deleteRecursive(this.dbDir);
            }
            catch (FileNotFoundException e) {
                throw new IOException(e);
            }
            this.started.set(false);
            logger.info("MySQL stopped: " + this.getCmdLineConnectionString());
        }
    }

    private static boolean deleteRecursive(File path) throws FileNotFoundException {
        File[] files;
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File f : files) {
                ret = ret && MySQLEmbeddedDB.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }
}

