/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.IOException;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.GenericStandaloneDB;

public class MySQLStandaloneDB
extends GenericStandaloneDB {
    protected MysqlDataSource dataSource;
    private final int port;

    public MySQLStandaloneDB(String databaseName) {
        this(databaseName, "root", null);
    }

    public MySQLStandaloneDB(String databaseName, String username, String password) {
        this(databaseName, username, password, "jdbc:mysql://localhost:3306/" + databaseName + "?createDatabaseIfNotExist=true&allowMultiQueries=true");
    }

    public MySQLStandaloneDB(String databaseName, String username, String password, String jdbcConnectionString) {
        super(databaseName, username, password, jdbcConnectionString);
        this.port = URI.create(jdbcConnectionString.substring(5)).getPort();
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.MYSQL;
    }

    public void initialize() throws IOException {
        super.initialize();
        this.dataSource = new MysqlDataSource();
        this.dataSource.setDatabaseName(this.databaseName);
        this.dataSource.setUser(this.username);
        this.dataSource.setPassword(this.password);
        this.dataSource.setPort(this.port);
        this.dataSource.setURL(this.jdbcConnectionString);
    }

    public void refreshTableNames() throws IOException {
        String query = String.format("select table_name from information_schema.tables where table_schema = '%s' and table_type = 'BASE TABLE';", this.databaseName);
        try {
            this.executeQuery(query, new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    MySQLStandaloneDB.this.allTables.clear();
                    while (resultSet.next()) {
                        MySQLStandaloneDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public DataSource getDataSource() throws IOException {
        return this.dataSource;
    }

    public String getCmdLineConnectionString() {
        return String.format("mysql -u%s -p%s -P%s %s", this.username, this.password, this.port, this.databaseName);
    }
}

