/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.h2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.tools.Server;
import org.killbill.commons.embeddeddb.EmbeddedDB;

public class H2EmbeddedDB
extends EmbeddedDB {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Server server;

    public H2EmbeddedDB() {
        this(UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString());
    }

    public H2EmbeddedDB(String databaseName, String username, String password) {
        this(databaseName, username, password, "jdbc:h2:mem:" + databaseName + ";MODE=LEGACY;DB_CLOSE_DELAY=-1");
    }

    public H2EmbeddedDB(String databaseName, String username, String password, String jdbcConnectionString) {
        super(databaseName, username, password, jdbcConnectionString);
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.H2;
    }

    public void initialize() throws IOException {
    }

    public void start() throws IOException {
        block3: {
            if (this.started.get()) {
                throw new IOException("H2 is already running: " + this.jdbcConnectionString);
            }
            this.createDataSource();
            try {
                this.server = Server.createWebServer((String[])new String[0]).start();
                logger.info(String.format("H2 started on http://127.0.0.1:8082. JDBC=%s, Username=%s, Password=%s", this.getJdbcConnectionString(), this.getUsername(), this.getPassword()));
            }
            catch (SQLException e) {
                if (String.valueOf(90061).equals(e.getSQLState())) break block3;
                throw new IOException(e);
            }
        }
        this.started.set(true);
        this.refreshTableNames();
    }

    public void refreshTableNames() throws IOException {
        String query = "select table_name from information_schema.tables where table_schema = current_schema() and table_type = 'BASE TABLE';";
        try {
            this.executeQuery("select table_name from information_schema.tables where table_schema = current_schema() and table_type = 'BASE TABLE';", new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    H2EmbeddedDB.this.allTables.clear();
                    while (resultSet.next()) {
                        H2EmbeddedDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void createDataSource() throws IOException {
        if (this.useConnectionPooling()) {
            this.dataSource = this.createHikariDataSource();
        } else {
            JdbcConnectionPool jdbcConnectionPool = JdbcConnectionPool.create((String)this.jdbcConnectionString, (String)this.username, (String)this.password);
            jdbcConnectionPool.setMaxConnections(100);
            this.dataSource = jdbcConnectionPool;
        }
    }

    public DataSource getDataSource() throws IOException {
        if (!this.started.get()) {
            throw new IOException("H2 is not running");
        }
        return super.getDataSource();
    }

    public void stop() throws IOException {
        if (!this.started.get()) {
            throw new IOException("H2 is not running");
        }
        super.stop();
        try (Connection connection = DriverManager.getConnection(this.jdbcConnectionString, this.username, this.password);
             Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN");
        }
        catch (Exception e) {
            logger.warn("Exception while trying to shutdown H2", (Throwable)e);
        }
        if (this.dataSource instanceof JdbcConnectionPool) {
            ((JdbcConnectionPool)this.dataSource).dispose();
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        this.started.set(false);
        logger.info(String.format("H2 stopped on http://127.0.0.1:8082. JDBC=%s, Username=%s, Password=%s", this.getJdbcConnectionString(), this.getUsername(), this.getPassword()));
    }

    public String getCmdLineConnectionString() {
        return "open " + this.server.getURL();
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

