/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.h2;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.tools.Server;
import org.killbill.commons.embeddeddb.EmbeddedDB;

public class H2EmbeddedDB
extends EmbeddedDB {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Server server;
    private JdbcConnectionPool dataSource;

    public H2EmbeddedDB() {
        this(UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString());
    }

    public H2EmbeddedDB(String databaseName, String username, String password) {
        this(databaseName, username, password, "jdbc:h2:mem:" + databaseName + ";MODE=MYSQL;DB_CLOSE_DELAY=-1;MVCC=true");
    }

    public H2EmbeddedDB(String databaseName, String username, String password, String jdbcConnectionString) {
        super(databaseName, username, password, jdbcConnectionString);
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.H2;
    }

    public void initialize() throws IOException {
        this.dataSource = JdbcConnectionPool.create((String)this.jdbcConnectionString, (String)this.username, (String)this.password);
    }

    public void start() throws IOException {
        if (this.started.get()) {
            throw new IOException("H2 is already running: " + this.jdbcConnectionString);
        }
        try {
            this.server = Server.createWebServer((String[])new String[0]).start();
            this.started.set(true);
            logger.info(String.format("H2 started on http://127.0.0.1:8082. JDBC=%s, Username=%s, Password=%s", this.getJdbcConnectionString(), this.getUsername(), this.getPassword()));
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        this.refreshTableNames();
    }

    public void refreshTableNames() throws IOException {
        String query = String.format("select table_name from information_schema.tables where table_catalog = '%s' and table_type = 'TABLE';", this.databaseName);
        try {
            this.executeQuery(query, new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    H2EmbeddedDB.this.allTables.clear();
                    while (resultSet.next()) {
                        H2EmbeddedDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public DataSource getDataSource() throws IOException {
        if (!this.started.get()) {
            throw new IOException("H2 is not running");
        }
        return this.dataSource;
    }

    public void stop() throws IOException {
        if (!this.started.get()) {
            throw new IOException("H2 is not running");
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.dataSource != null) {
            this.dataSource.dispose();
        }
        logger.info(String.format("H2 stopped on http://127.0.0.1:8082. JDBC=%s, Username=%s, Password=%s", this.getJdbcConnectionString(), this.getUsername(), this.getPassword()));
    }

    public String getCmdLineConnectionString() {
        return "open " + this.server.getURL();
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

