/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.killbill.billing.osgi.api.config.PluginConfig;
import org.killbill.billing.osgi.api.config.PluginJavaConfig;
import org.killbill.billing.osgi.api.config.PluginLanguage;
import org.killbill.billing.osgi.api.config.PluginType;
import org.killbill.billing.osgi.config.OSGIConfig;
import org.killbill.commons.utils.io.Resources;
import org.testng.Assert;

public class SetupBundleWithAssertion {
    private static final String JRUBY_BUNDLE_RESOURCE = "killbill-osgi-bundles-jruby";
    private final String bundleName;
    private final OSGIConfig config;
    private final String killbillVersion;
    private final File rootInstallDir;

    public SetupBundleWithAssertion(String bundleName, OSGIConfig config, String killbillVersion) {
        this.bundleName = bundleName;
        this.config = config;
        this.killbillVersion = killbillVersion;
        this.rootInstallDir = new File(config.getRootInstallationDir());
    }

    public void setupJrubyBundle() {
        try {
            this.installJrubyJar();
            URL resourceUrl = Resources.getResource((String)this.bundleName);
            File unzippedRubyPlugin = SetupBundleWithAssertion.unGzip(new File(resourceUrl.getFile()), this.rootInstallDir);
            StringBuilder tmp = new StringBuilder(this.rootInstallDir.getAbsolutePath());
            tmp.append("/plugins/").append(PluginLanguage.RUBY.toString().toLowerCase());
            File destination = new File(tmp.toString());
            if (!destination.exists()) {
                Assert.assertTrue((boolean)destination.mkdirs(), (String)("Unable to create directory " + destination.getAbsolutePath()));
            }
            SetupBundleWithAssertion.unTar(unzippedRubyPlugin, destination);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (ArchiveException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void setupJavaBundle() {
        PluginJavaConfig pluginConfig = this.extractJavaBundleTestResource();
        Assert.assertNotNull((Object)pluginConfig);
        this.setupDirectoryStructure((PluginConfig)pluginConfig);
        File target = new File(pluginConfig.getPluginVersionRoot().getAbsolutePath(), pluginConfig.getPluginVersionnedName() + ".jar");
        try (FileInputStream input = new FileInputStream(pluginConfig.getBundleJarPath());
             FileOutputStream out = new FileOutputStream(target);){
            ((InputStream)input).transferTo(out);
            this.createConfigFile((PluginConfig)pluginConfig);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void cleanBundleInstallDir() {
        if (this.rootInstallDir.exists()) {
            SetupBundleWithAssertion.deleteDirectory(this.rootInstallDir, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfigFile(PluginConfig pluginConfig) throws IOException {
        try (PrintStream printStream = null;){
            File configFile = new File(pluginConfig.getPluginVersionRoot(), this.config.getOSGIKillbillPropertyName());
            Assert.assertTrue((boolean)configFile.createNewFile(), (String)("Unable to create file " + configFile.getAbsolutePath()));
            printStream = new PrintStream((OutputStream)new FileOutputStream(configFile), true, StandardCharsets.UTF_8);
            printStream.print("pluginType=" + PluginType.NOTIFICATION);
        }
    }

    private void setupDirectoryStructure(PluginConfig pluginConfig) {
        this.cleanBundleInstallDir();
        Assert.assertTrue((boolean)pluginConfig.getPluginVersionRoot().mkdirs(), (String)("Unable to create directory " + pluginConfig.getPluginVersionRoot().getAbsolutePath()));
    }

    private static void deleteDirectory(File path, boolean deleteParent) {
        if (path == null) {
            return;
        }
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        SetupBundleWithAssertion.deleteDirectory(f, true);
                    }
                    Assert.assertTrue((boolean)f.delete(), (String)("Unable to delete file " + f.getAbsolutePath()));
                }
            }
            if (deleteParent) {
                Assert.assertTrue((boolean)path.delete(), (String)("Unable to delete file " + path.delete()));
            }
        }
    }

    private void installJrubyJar() throws IOException {
        String resourceName = "killbill-osgi-bundles-jruby.jar";
        URL resourceUrl = Resources.getResource((String)"killbill-osgi-bundles-jruby.jar");
        File rubyJarInput = new File(resourceUrl.getFile());
        File platform = new File(this.rootInstallDir, "platform");
        if (!platform.exists()) {
            Assert.assertTrue((boolean)platform.mkdir(), (String)("Unable to create directory " + platform.getAbsolutePath()));
        }
        File rubyJarDestination = new File(platform, "jruby.jar");
        try (FileInputStream from = new FileInputStream(rubyJarInput);
             FileOutputStream to = new FileOutputStream(rubyJarDestination);){
            from.transferTo(to);
        }
    }

    private PluginJavaConfig extractJavaBundleTestResource() {
        String[] parts;
        String lastPart;
        String resourceName = this.bundleName + "-jar-with-dependencies.jar";
        URL resourceUrl = Resources.getResource((String)resourceName);
        if (resourceUrl != null && (lastPart = (parts = resourceUrl.getPath().split("/"))[parts.length - 1]).startsWith(this.bundleName)) {
            return this.createPluginJavaConfig(resourceUrl.getPath());
        }
        return null;
    }

    private PluginJavaConfig createPluginJavaConfig(final String bundleTestResourcePath) {
        return new PluginJavaConfig(){

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.getPluginKey().equals(((PluginJavaConfig)o).getPluginKey());
            }

            public int hashCode() {
                return this.getPluginKey().hashCode();
            }

            public int compareTo(PluginConfig o) {
                return this.getPluginKey().compareTo(o.getPluginKey());
            }

            public String getBundleJarPath() {
                return bundleTestResourcePath;
            }

            public String getPluginKey() {
                return "key";
            }

            public String getPluginName() {
                return SetupBundleWithAssertion.this.bundleName;
            }

            public PluginType getPluginType() {
                return PluginType.PAYMENT;
            }

            public String getVersion() {
                return SetupBundleWithAssertion.this.killbillVersion;
            }

            public String getPluginVersionnedName() {
                return SetupBundleWithAssertion.this.bundleName + "-" + SetupBundleWithAssertion.this.killbillVersion;
            }

            public File getPluginVersionRoot() {
                StringBuilder tmp = new StringBuilder(SetupBundleWithAssertion.this.rootInstallDir.getAbsolutePath());
                tmp.append("/plugins/").append(PluginLanguage.JAVA.toString().toLowerCase()).append("/").append(SetupBundleWithAssertion.this.bundleName).append("/").append(SetupBundleWithAssertion.this.killbillVersion);
                return new File(tmp.toString());
            }

            public PluginLanguage getPluginLanguage() {
                return PluginLanguage.JAVA;
            }

            public boolean isSelectedForStart() {
                return true;
            }

            public boolean isDisabled() {
                return false;
            }
        };
    }

    private static void unTar(File inputFile, File outputDir) throws IOException, ArchiveException {
        try (FileInputStream is = new FileInputStream(inputFile);){
            TarArchiveEntry entry;
            TarArchiveInputStream archiveInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
            while ((entry = (TarArchiveEntry)archiveInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                ((InputStream)is).transferTo(outputFileStream);
            }
        }
    }

    private static File unGzip(File inputFile, File outputDir) throws IOException {
        File outputFile = new File(outputDir, inputFile.getName().substring(0, inputFile.getName().length() - 3));
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(inputFile));){
            File file;
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                int c = in.read();
                while (c != -1) {
                    out.write(c);
                    c = in.read();
                }
                file = outputFile;
            }
            return file;
        }
    }
}

