/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi.glue;

import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.plugin.api.CatalogPluginApi;
import org.killbill.billing.control.plugin.api.PaymentControlPluginApi;
import org.killbill.billing.currency.api.CurrencyConversionApi;
import org.killbill.billing.currency.plugin.api.CurrencyPluginApi;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.plugin.api.EntitlementPluginApi;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.invoice.plugin.api.InvoicePluginApi;
import org.killbill.billing.osgi.api.Healthcheck;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.osgi.api.OSGISingleServiceRegistration;
import org.killbill.billing.osgi.api.ServiceDiscoveryRegistry;
import org.killbill.billing.overdue.api.OverdueApi;
import org.killbill.billing.payment.api.AdminPaymentApi;
import org.killbill.billing.payment.api.InvoicePaymentApi;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.glue.KillBillPlatformModuleBase;
import org.killbill.billing.platform.test.config.TestKillbillConfigSource;
import org.killbill.billing.platform.test.glue.TestPlatformModuleWithEmbeddedDB;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.usage.api.UsageUserApi;
import org.killbill.billing.usage.plugin.api.UsagePluginApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.ExportUserApi;
import org.killbill.billing.util.api.RecordIdApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.killbill.commons.health.api.HealthCheckRegistry;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.impl.NoOpMetricRegistry;

public class TestIntegrationModule
extends KillBillPlatformModuleBase {
    public TestIntegrationModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        this.install((Module)new TestPlatformModuleWithEmbeddedDB(this.configSource, true, (OSGIConfigProperties)((TestKillbillConfigSource)this.configSource)));
        this.bind(MetricRegistry.class).to(NoOpMetricRegistry.class);
        this.bind(HealthCheckRegistry.class).toProvider(Providers.of(null));
        this.bind(Clock.class).to(ClockMock.class);
        this.bind(ClockMock.class).asEagerSingleton();
        this.bindOsgiKillbill();
        this.bindOsgiServiceRegistration();
    }

    protected void bindOsgiKillbill() {
        this.bind(AccountUserApi.class).toProvider(Providers.of(null));
        this.bind(CatalogUserApi.class).toProvider(Providers.of(null));
        this.bind(InvoicePaymentApi.class).toProvider(Providers.of(null));
        this.bind(InvoiceUserApi.class).toProvider(Providers.of(null));
        this.bind(PaymentApi.class).toProvider(Providers.of(null));
        this.bind(TenantUserApi.class).toProvider(Providers.of(null));
        this.bind(UsageUserApi.class).toProvider(Providers.of(null));
        this.bind(AuditUserApi.class).toProvider(Providers.of(null));
        this.bind(CustomFieldUserApi.class).toProvider(Providers.of(null));
        this.bind(ExportUserApi.class).toProvider(Providers.of(null));
        this.bind(TagUserApi.class).toProvider(Providers.of(null));
        this.bind(EntitlementApi.class).toProvider(Providers.of(null));
        this.bind(SubscriptionApi.class).toProvider(Providers.of(null));
        this.bind(CurrencyConversionApi.class).toProvider(Providers.of(null));
        this.bind(RecordIdApi.class).toProvider(Providers.of(null));
        this.bind(SecurityApi.class).toProvider(Providers.of(null));
        this.bind(AdminPaymentApi.class).toProvider(Providers.of(null));
        this.bind(OverdueApi.class).toProvider(Providers.of(null));
    }

    protected void bindOsgiServiceRegistration() {
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<PaymentPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<PaymentPluginApi>(PaymentPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<CurrencyPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<CurrencyPluginApi>(CurrencyPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<InvoicePluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<InvoicePluginApi>(InvoicePluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<PaymentControlPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<PaymentControlPluginApi>(PaymentControlPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<CatalogPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<CatalogPluginApi>(CatalogPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<EntitlementPluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<EntitlementPluginApi>(EntitlementPluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<Healthcheck>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<Healthcheck>(Healthcheck.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<ServiceDiscoveryRegistry>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<ServiceDiscoveryRegistry>(ServiceDiscoveryRegistry.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<UsagePluginApi>>(){}).toInstance(new TestPlatformPaymentProviderPluginRegistry<UsagePluginApi>(UsagePluginApi.class));
        this.bind((TypeLiteral)new TypeLiteral<OSGISingleServiceRegistration<MetricRegistry>>(){}).toInstance(new TestOSGISingleServiceRegistration<MetricRegistry>(MetricRegistry.class));
    }

    static final class TestOSGISingleServiceRegistration<T>
    implements OSGISingleServiceRegistration<T> {
        private final Map<String, T> pluginsByName = new ConcurrentHashMap<String, T>();
        private final Class<T> serviceType;

        public TestOSGISingleServiceRegistration(Class<T> serviceType) {
            this.serviceType = serviceType;
        }

        public void registerService(OSGIServiceDescriptor desc, T service) {
            this.pluginsByName.put(desc.getPluginName(), service);
        }

        public void unregisterService(String serviceName) {
            this.pluginsByName.remove(serviceName);
        }

        public Class<T> getServiceType() {
            return this.serviceType;
        }

        public T getService() {
            return this.pluginsByName.values().stream().findFirst().orElse(null);
        }
    }

    public static final class TestPlatformPaymentProviderPluginRegistry<T>
    implements OSGIServiceRegistration<T> {
        private final Map<String, T> pluginsByName = new ConcurrentHashMap<String, T>();
        private final Class<T> serviceType;

        public TestPlatformPaymentProviderPluginRegistry(Class<T> serviceType) {
            this.serviceType = serviceType;
        }

        public void registerService(OSGIServiceDescriptor desc, T service) {
            this.pluginsByName.put(desc.getRegistrationName(), service);
        }

        public void unregisterService(String serviceName) {
            this.pluginsByName.remove(serviceName);
        }

        public T getServiceForName(String name) {
            return this.pluginsByName.get(name);
        }

        public Set<String> getAllServices() {
            return this.pluginsByName.keySet();
        }

        public Class<T> getServiceType() {
            return this.serviceType;
        }
    }
}

