/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.UUID;
import org.killbill.billing.beatrix.integration.osgi.TestOSGIBase;
import org.killbill.billing.beatrix.integration.osgi.util.SetupBundleWithAssertion;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.osgi.api.PaymentPluginApiWithTestControl;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.payment.plugin.api.PaymentPluginApiException;
import org.killbill.billing.payment.plugin.api.PaymentTransactionInfoPlugin;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPaymentOSGIWithTestPaymentBundle
extends TestOSGIBase {
    private static final String TEST_PLUGIN_NAME = "osgi-payment-plugin";
    private static final String BUNDLE_TEST_RESOURCE = "killbill-osgi-bundles-test-payment";

    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        String killbillVersion = System.getProperty("killbill.version");
        SetupBundleWithAssertion setupTest = new SetupBundleWithAssertion(BUNDLE_TEST_RESOURCE, this.osgiConfig, killbillVersion);
        setupTest.setupJavaBundle();
    }

    @Override
    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        ((PaymentPluginApiWithTestControl)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, TEST_PLUGIN_NAME)).resetToNormalBehavior();
    }

    @Test(groups={"slow"})
    public void testBasicProcessPaymentOK() throws Exception {
        PaymentPluginApi paymentPluginApi = (PaymentPluginApi)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, TEST_PLUGIN_NAME);
        UUID paymentId = UUID.randomUUID();
        BigDecimal amount = BigDecimal.TEN;
        Currency currency = Currency.USD;
        PaymentTransactionInfoPlugin PaymentTransactionInfoPlugin2 = paymentPluginApi.purchasePayment(UUID.randomUUID(), paymentId, UUID.randomUUID(), UUID.randomUUID(), amount, currency, Collections.emptyList(), this.callContext);
        Assert.assertEquals((Object)PaymentTransactionInfoPlugin2.getKbPaymentId(), (Object)paymentId);
        Assert.assertEquals((int)PaymentTransactionInfoPlugin2.getAmount().compareTo(amount), (int)0);
        Assert.assertEquals((Object)PaymentTransactionInfoPlugin2.getCurrency(), (Object)currency);
    }

    @Test(groups={"slow"})
    public void testBasicProcessPaymentWithPaymentPluginApiException() throws Exception {
        PaymentPluginApiWithTestControl paymentPluginApi = (PaymentPluginApiWithTestControl)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, TEST_PLUGIN_NAME);
        String errorType = "test-error";
        String errorMessage = "foo";
        PaymentPluginApiException exception = new PaymentPluginApiException("test-error", "foo");
        paymentPluginApi.setPaymentPluginApiExceptionOnNextCalls(exception);
        try {
            paymentPluginApi.purchasePayment(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), BigDecimal.TEN, Currency.USD, Collections.emptyList(), this.callContext);
            Assert.fail((String)("Expected to fail with " + exception.toString()));
        }
        catch (PaymentPluginApiException e) {
            Assert.assertEquals((String)e.getErrorType(), (String)"test-error");
            Assert.assertEquals((String)e.getErrorMessage(), (String)"foo");
        }
    }

    @Test(groups={"slow"})
    public void testBasicProcessPaymentWithRuntimeException() throws Exception {
        PaymentPluginApiWithTestControl paymentPluginApi = (PaymentPluginApiWithTestControl)this.getTestApi(this.paymentPluginApiOSGIServiceRegistration, TEST_PLUGIN_NAME);
        String message = "test-error";
        RuntimeException exception = new RuntimeException("test-error");
        paymentPluginApi.setPaymentRuntimeExceptionOnNextCalls(exception);
        try {
            paymentPluginApi.purchasePayment(UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), BigDecimal.TEN, Currency.USD, Collections.emptyList(), this.callContext);
            Assert.fail((String)("Expected to fail with " + exception.toString()));
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test-error");
        }
    }
}

