/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import org.awaitility.Awaitility;
import org.killbill.billing.beatrix.integration.osgi.glue.TestIntegrationModule;
import org.killbill.billing.currency.plugin.api.CurrencyPluginApi;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.osgi.config.OSGIConfig;
import org.killbill.billing.payment.plugin.api.PaymentPluginApi;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.jndi.ReferenceableDataSourceSpy;
import org.killbill.billing.platform.test.PlatformDBTestingHelper;
import org.killbill.billing.platform.test.config.TestKillbillConfigSource;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.ClockMock;
import org.mockito.Mockito;
import org.skife.jdbi.v2.IDBI;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class TestOSGIBase {
    @Inject
    protected Lifecycle lifecycle;
    @Inject
    protected BusService busService;
    @Inject
    @Named(value="externalBus")
    protected PersistentBus externalBus;
    @Inject
    protected IDBI dbi;
    @Inject
    protected DataSource dataSource;
    @Inject
    @Named(value="osgi")
    protected DataSource osgiDataSource;
    @Inject
    protected OSGIConfig osgiConfig;
    @Inject
    protected ClockMock clock;
    @Inject
    protected OSGIServiceRegistration<PaymentPluginApi> paymentPluginApiOSGIServiceRegistration;
    @Inject
    protected OSGIServiceRegistration<CurrencyPluginApi> currencyPluginApiOSGIServiceRegistration;
    protected final TestKillbillConfigSource configSource;
    protected CallContext callContext;

    public TestOSGIBase() {
        try {
            this.configSource = new TestKillbillConfigSource(null, PlatformDBTestingHelper.class);
        }
        catch (Exception e) {
            AssertionError assertionError = new AssertionError((Object)"Initialization error");
            ((Throwable)((Object)assertionError)).initCause(e);
            throw assertionError;
        }
        this.callContext = (CallContext)Mockito.mock(CallContext.class);
    }

    @BeforeSuite(groups={"slow"})
    public void beforeSuite() throws Exception {
        PlatformDBTestingHelper.get().start();
    }

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        Injector g = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new TestIntegrationModule((KillbillConfigSource)this.configSource)});
        g.injectMembers((Object)this);
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        try {
            PlatformDBTestingHelper.get().getInstance().cleanupAllTables();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clock.resetDeltaFromReality();
        this.lifecycle.fireStartupSequencePriorEventRegistration();
        this.lifecycle.fireStartupSequencePostEventRegistration();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.lifecycle.fireShutdownSequencePriorEventUnRegistration();
        this.lifecycle.fireShutdownSequencePostEventUnRegistration();
    }

    @AfterClass(groups={"slow"})
    public void afterClass() throws Exception {
        if (this.dataSource instanceof ReferenceableDataSourceSpy && ((ReferenceableDataSourceSpy)this.dataSource).getDataSource() instanceof HikariDataSource) {
            ((HikariDataSource)((ReferenceableDataSourceSpy)this.dataSource).getDataSource()).close();
        }
        if (this.osgiDataSource instanceof ReferenceableDataSourceSpy && ((ReferenceableDataSourceSpy)this.osgiDataSource).getDataSource() instanceof HikariDataSource) {
            ((HikariDataSource)((ReferenceableDataSourceSpy)this.osgiDataSource).getDataSource()).close();
        }
    }

    @AfterSuite(groups={"slow"})
    public void afterSuite() throws Exception {
        try {
            PlatformDBTestingHelper.get().getInstance().stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected <T> T getTestApi(final OSGIServiceRegistration<T> serviceRegistration, final String serviceName) throws Exception {
        Awaitility.await().until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return serviceRegistration.getServiceForName(serviceName) != null;
            }
        });
        return (T)serviceRegistration.getServiceForName(serviceName);
    }
}

