/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test.glue;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.test.PlatformDBTestingHelper;
import org.killbill.billing.platform.test.glue.TestPlatformModule;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.killbill.commons.jdbi.transaction.NotificationTransactionHandler;
import org.killbill.commons.jdbi.transaction.RestartTransactionRunner;
import org.killbill.queue.InTransaction;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.TransactionHandler;

public class TestPlatformModuleWithEmbeddedDB
extends TestPlatformModule {
    private final DatabaseTransactionNotificationApi databaseTransactionNotificationApi = new DatabaseTransactionNotificationApi();
    private final TransactionHandler transactionHandler;

    public TestPlatformModuleWithEmbeddedDB(KillbillConfigSource configSource, boolean withOSGI, @Nullable OSGIConfigProperties osgiConfigProperties) {
        super(configSource, withOSGI, osgiConfigProperties, null);
        NotificationTransactionHandler notificationTransactionHandler = new NotificationTransactionHandler(this.databaseTransactionNotificationApi);
        this.transactionHandler = new RestartTransactionRunner((TransactionHandler)notificationTransactionHandler);
    }

    protected void configure() {
        super.configure();
        this.bind(DatabaseTransactionNotificationApi.class).toInstance((Object)this.databaseTransactionNotificationApi);
        this.bind(TransactionHandler.class).toInstance((Object)this.transactionHandler);
    }

    protected void configureEmbeddedDB() {
        PlatformDBTestingHelper platformDBTestingHelper = this.getPlatformDBTestingHelper();
        EmbeddedDB instance = platformDBTestingHelper.getInstance();
        this.bind(EmbeddedDB.class).toInstance((Object)instance);
        this.bind(DataSource.class).toInstance((Object)platformDBTestingHelper.getDataSource());
    }

    @Provides
    @Singleton
    protected IDBI provideIDBIInAComplicatedWayBecauseOf627() {
        DBI dbi = (DBI)this.getPlatformDBTestingHelper().getDBI();
        dbi.setTransactionHandler(this.transactionHandler);
        InTransaction.setupDBI((DBI)dbi);
        return dbi;
    }

    @Provides
    @Singleton
    @Named(value="Queue")
    protected IDBI provideIDBIInAComplicatedWayBecauseOf627(IDBI idbi) {
        InTransaction.setupDBI((DBI)((DBI)idbi));
        return idbi;
    }

    protected PlatformDBTestingHelper getPlatformDBTestingHelper() {
        return PlatformDBTestingHelper.get();
    }
}

