/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.beatrix.integration.osgi;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.awaitility.Awaitility;
import org.killbill.billing.ObjectType;
import org.killbill.billing.beatrix.integration.osgi.TestOSGIBase;
import org.killbill.billing.beatrix.integration.osgi.util.ExternalBusTestEvent;
import org.killbill.billing.beatrix.integration.osgi.util.SetupBundleWithAssertion;
import org.killbill.billing.notification.plugin.api.ExtBusEvent;
import org.killbill.billing.notification.plugin.api.ExtBusEventType;
import org.killbill.bus.api.BusEvent;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestJrubyNotificationPlugin
extends TestOSGIBase {
    private static final String BUNDLE_TEST_RESOURCE_PREFIX = "killbill-notification-test";
    private static final String BUNDLE_TEST_RESOURCE = "killbill-notification-test.tar.gz";
    private static final Path MAGIC_FILE_PATH = Paths.get(FileSystems.getDefault().getSeparator() + "var", "tmp", "killbill-notification-test.txt");

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        String killbillVersion = System.getProperty("killbill.version");
        SetupBundleWithAssertion setupTest = new SetupBundleWithAssertion(BUNDLE_TEST_RESOURCE, this.osgiConfig, killbillVersion);
        setupTest.setupJrubyBundle();
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        try {
            this.cleanupMagicFile();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        super.afterMethod();
        Assert.assertFalse((boolean)Files.exists(MAGIC_FILE_PATH, new LinkOption[0]));
    }

    @Test(groups={"slow"})
    public void testOnEventForAccountCreation() throws Exception {
        UUID objectId = UUID.randomUUID();
        UUID accountId = UUID.randomUUID();
        UUID tenantId = UUID.randomUUID();
        ExternalBusTestEvent firstEvent = new ExternalBusTestEvent(objectId, ObjectType.ACCOUNT, ExtBusEventType.ACCOUNT_CREATION, accountId, tenantId, null, 0L, 1L, UUID.randomUUID());
        this.externalBus.post((BusEvent)firstEvent);
        this.checkThePluginGotTheEvent(firstEvent, ExtBusEventType.TAG_CREATION);
        ExternalBusTestEvent secondEvent = new ExternalBusTestEvent(objectId, ObjectType.ACCOUNT, ExtBusEventType.ACCOUNT_CHANGE, accountId, tenantId, null, 0L, 1L, UUID.randomUUID());
        this.externalBus.post((BusEvent)secondEvent);
        this.checkThePluginGotTheEvent(secondEvent, ExtBusEventType.TAG_DELETION);
    }

    private void checkThePluginGotTheEvent(ExtBusEvent extBusEvent, ExtBusEventType expectedEventType) throws Exception {
        Awaitility.await().until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Files.exists(MAGIC_FILE_PATH, new LinkOption[0]);
            }
        });
        String actualContent = com.google.common.io.Files.toString((File)new File(MAGIC_FILE_PATH.toUri()), (Charset)Charsets.UTF_8);
        String expectedContent = String.format("%s-%s-%s-%s-%s\n", expectedEventType, ObjectType.ACCOUNT, extBusEvent.getObjectId(), extBusEvent.getAccountId(), extBusEvent.getTenantId());
        Assert.assertEquals((String)actualContent, (String)expectedContent);
        this.cleanupMagicFile();
    }

    private void cleanupMagicFile() throws IOException {
        Files.delete(MAGIC_FILE_PATH);
    }
}

